/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SessionMonitor
implements HttpSessionListener {
    protected static SessionMonitor sessionMonitor;
    protected List<HttpSessionListener> listeners;
    protected ConcurrentMap<String, HttpSession> sessionMap;

    public SessionMonitor() {
        if (sessionMonitor == null) {
            sessionMonitor = this;
            this.listeners = new CopyOnWriteArrayList<HttpSessionListener>();
            this.sessionMap = new ConcurrentHashMap<String, HttpSession>();
        }
    }

    public static SessionMonitor getInstance() {
        return sessionMonitor;
    }

    public void registerListener(HttpSessionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(HttpSessionListener listener) {
        this.listeners.remove(listener);
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        HttpSession session = httpSessionEvent.getSession();
        this.sessionMap.putIfAbsent(session.getId(), session);
        for (HttpSessionListener listener : this.listeners) {
            listener.sessionCreated(httpSessionEvent);
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        HttpSession session = httpSessionEvent.getSession();
        this.sessionMap.remove(session.getId());
        for (HttpSessionListener listener : this.listeners) {
            listener.sessionDestroyed(httpSessionEvent);
        }
    }

    public HttpSession getSession(String sessionId) {
        return (HttpSession)this.sessionMap.get(sessionId);
    }

    public Iterator<String> iterator() {
        return this.sessionMap.keySet().iterator();
    }

    public void destroy() {
        this.listeners.clear();
        this.sessionMap.clear();
    }
}

