/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.net;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jodd.io.StreamUtil;
import jodd.util.BinarySearchBase;
import jodd.util.CharUtil;
import jodd.util.StringUtil;

public class HtmlDecoder {
    private static final Map<String, char[]> ENTITY_MAP;
    private static final char[][] ENTITY_NAMES;

    public static String decode(String html) {
        int ndx = html.indexOf(38);
        if (ndx == -1) {
            return html;
        }
        StringBuilder result = new StringBuilder(html.length());
        int lastIndex = 0;
        int len = html.length();
        block0: while (ndx != -1) {
            result.append(html.substring(lastIndex, ndx));
            lastIndex = ndx;
            while (html.charAt(lastIndex) != ';') {
                if (++lastIndex != len) continue;
                lastIndex = ndx;
                break block0;
            }
            if (html.charAt(ndx + 1) == '#') {
                int radix;
                char c = html.charAt(ndx + 2);
                if (c == 'x' || c == 'X') {
                    radix = 16;
                    ndx += 3;
                } else {
                    radix = 10;
                    ndx += 2;
                }
                String number = html.substring(ndx, lastIndex);
                int i = Integer.parseInt(number, radix);
                result.append((char)i);
                ++lastIndex;
            } else {
                String encodeToken = html.substring(ndx + 1, lastIndex);
                char[] replacement = ENTITY_MAP.get(encodeToken);
                if (replacement == null) {
                    result.append('&');
                    lastIndex = ndx + 1;
                } else {
                    result.append(replacement);
                    ++lastIndex;
                }
            }
            ndx = html.indexOf(38, lastIndex);
        }
        result.append(html.substring(lastIndex));
        return result.toString();
    }

    public static String detectName(CharSequence input, int ndx) {
        final Ptr ptr = new Ptr();
        int firstIndex = 0;
        int lastIndex = ENTITY_NAMES.length - 1;
        int len = input.length();
        char[] lastName = null;
        BinarySearchBase binarySearch = new BinarySearchBase(){

            @Override
            protected int compare(int index) {
                char[] name = ENTITY_NAMES[index];
                if (ptr.offset >= name.length) {
                    return -1;
                }
                return name[ptr.offset] - ptr.c;
            }
        };
        do {
            ptr.c = input.charAt(ndx);
            if (!CharUtil.isAlphaOrDigit(ptr.c)) {
                return lastName != null ? new String(lastName) : null;
            }
            if ((firstIndex = binarySearch.findFirst(firstIndex, lastIndex)) < 0) {
                return lastName != null ? new String(lastName) : null;
            }
            char[] element = ENTITY_NAMES[firstIndex];
            if (element.length == ptr.offset + 1) {
                lastName = ENTITY_NAMES[firstIndex];
            }
            if (firstIndex == (lastIndex = binarySearch.findLast(firstIndex, lastIndex))) {
                for (int i = ptr.offset; i < element.length; ++i) {
                    if (element[i] != input.charAt(ndx)) {
                        return lastName != null ? new String(lastName) : null;
                    }
                    ++ndx;
                }
                return new String(element);
            }
            ++ptr.offset;
        } while (++ndx != len);
        return lastName != null ? new String(lastName) : null;
    }

    public static char[] lookup(String name) {
        return ENTITY_MAP.get(name);
    }

    static {
        Properties entityReferences = new Properties();
        String propertiesName = HtmlDecoder.class.getSimpleName() + ".properties";
        InputStream is = HtmlDecoder.class.getResourceAsStream(propertiesName);
        try {
            entityReferences.load(is);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Can't load properties", ex);
        }
        finally {
            StreamUtil.close(is);
        }
        ENTITY_MAP = new HashMap<String, char[]>(entityReferences.size());
        Enumeration<?> keys = entityReferences.propertyNames();
        while (keys.hasMoreElements()) {
            char[] chars;
            String name = (String)keys.nextElement();
            String values = entityReferences.getProperty(name);
            String[] array = StringUtil.splitc(values, ',');
            String hex = array[0];
            char value = (char)Integer.parseInt(hex, 16);
            if (array.length == 2) {
                String hex2 = array[1];
                char value2 = (char)Integer.parseInt(hex2, 16);
                chars = new char[]{value, value2};
            } else {
                chars = new char[]{value};
            }
            ENTITY_MAP.put(name, chars);
        }
        ENTITY_NAMES = new char[ENTITY_MAP.size()][];
        int i = 0;
        for (String name : ENTITY_MAP.keySet()) {
            HtmlDecoder.ENTITY_NAMES[i++] = name.toCharArray();
        }
        Arrays.sort(ENTITY_NAMES, Comparator.comparing(String::new));
    }

    private static final class Ptr {
        public int offset;
        public char c;

        private Ptr() {
        }
    }
}

