/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.xml.bind.JAXB;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.Query;
import org.jooq.QueryPart;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.conf.Settings;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.jooq.impl.SQLDataType;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StopWatch;
import org.jooq.tools.StringUtils;
import org.jooq.tools.csv.CSVReader;
import org.jooq.util.AbstractTypedElementDefinition;
import org.jooq.util.ArrayDefinition;
import org.jooq.util.CatalogDefinition;
import org.jooq.util.CatalogVersionProvider;
import org.jooq.util.CheckConstraintDefinition;
import org.jooq.util.ColumnDefinition;
import org.jooq.util.DataTypeDefinition;
import org.jooq.util.Database;
import org.jooq.util.DefaultDataTypeDefinition;
import org.jooq.util.DefaultEnumDefinition;
import org.jooq.util.DefaultRelations;
import org.jooq.util.DefaultUniqueKeyDefinition;
import org.jooq.util.Definition;
import org.jooq.util.DomainDefinition;
import org.jooq.util.EnumDefinition;
import org.jooq.util.ForeignKeyDefinition;
import org.jooq.util.IdentityDefinition;
import org.jooq.util.PackageDefinition;
import org.jooq.util.Relations;
import org.jooq.util.RoutineDefinition;
import org.jooq.util.SchemaDefinition;
import org.jooq.util.SchemaVersionProvider;
import org.jooq.util.SequenceDefinition;
import org.jooq.util.TableDefinition;
import org.jooq.util.UDTDefinition;
import org.jooq.util.UniqueKeyDefinition;
import org.jooq.util.jaxb.CustomType;
import org.jooq.util.jaxb.EnumType;
import org.jooq.util.jaxb.ForcedType;
import org.jooq.util.jaxb.RegexFlag;
import org.jooq.util.jaxb.Schema;

public abstract class AbstractDatabase
implements Database {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractDatabase.class);
    private Properties properties;
    private SQLDialect dialect;
    private Connection connection;
    private List<RegexFlag> regexFlags;
    private List<Database.Filter> filters;
    private String[] excludes;
    private String[] includes;
    private boolean includeExcludeColumns;
    private boolean includeTables = true;
    private boolean includeRoutines = true;
    private boolean includePackages = true;
    private boolean includeUDTs = true;
    private boolean includeSequences = true;
    private boolean includePrimaryKeys = true;
    private boolean includeUniqueKeys = true;
    private boolean includeForeignKeys = true;
    private String[] recordVersionFields;
    private String[] recordTimestampFields;
    private String[] syntheticPrimaryKeys;
    private String[] overridePrimaryKeys;
    private boolean supportsUnsignedTypes;
    private boolean ignoreProcedureReturnValues;
    private boolean dateAsTimestamp;
    private List<Schema> configuredSchemata;
    private List<CustomType> configuredCustomTypes;
    private List<EnumType> configuredEnumTypes;
    private List<ForcedType> configuredForcedTypes;
    private SchemaVersionProvider schemaVersionProvider;
    private CatalogVersionProvider catalogVersionProvider;
    private List<String> inputSchemata;
    private List<CatalogDefinition> catalogs;
    private List<SchemaDefinition> schemata;
    private List<SequenceDefinition> sequences;
    private List<IdentityDefinition> identities;
    private List<UniqueKeyDefinition> uniqueKeys;
    private List<ForeignKeyDefinition> foreignKeys;
    private List<CheckConstraintDefinition> checkConstraints;
    private List<TableDefinition> tables;
    private List<EnumDefinition> enums;
    private List<DomainDefinition> domains;
    private List<UDTDefinition> udts;
    private List<ArrayDefinition> arrays;
    private List<RoutineDefinition> routines;
    private List<PackageDefinition> packages;
    private Relations relations;
    private boolean includeRelations = true;
    private boolean tableValuedFunctions = true;
    private transient Map<SchemaDefinition, List<SequenceDefinition>> sequencesBySchema;
    private transient Map<SchemaDefinition, List<IdentityDefinition>> identitiesBySchema;
    private transient Map<SchemaDefinition, List<UniqueKeyDefinition>> uniqueKeysBySchema;
    private transient Map<SchemaDefinition, List<ForeignKeyDefinition>> foreignKeysBySchema;
    private transient Map<SchemaDefinition, List<CheckConstraintDefinition>> checkConstraintsBySchema;
    private transient Map<SchemaDefinition, List<TableDefinition>> tablesBySchema;
    private transient Map<SchemaDefinition, List<EnumDefinition>> enumsBySchema;
    private transient Map<SchemaDefinition, List<UDTDefinition>> udtsBySchema;
    private transient Map<SchemaDefinition, List<ArrayDefinition>> arraysBySchema;
    private transient Map<SchemaDefinition, List<RoutineDefinition>> routinesBySchema;
    private transient Map<SchemaDefinition, List<PackageDefinition>> packagesBySchema;
    private transient boolean initialised;
    private final Map<Table<?>, Boolean> exists = new HashMap();
    private final Map<String, Pattern> patterns = new HashMap<String, Pattern>();

    protected AbstractDatabase() {
        this.filters = new ArrayList<Database.Filter>();
    }

    @Override
    public final SQLDialect getDialect() {
        if (this.dialect == null) {
            this.dialect = this.create().configuration().dialect();
        }
        return this.dialect;
    }

    @Override
    public final void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Override
    public final Connection getConnection() {
        return this.connection;
    }

    @Override
    public final DSLContext create() {
        return this.create(false);
    }

    protected final DSLContext create(boolean muteExceptions) {
        final Configuration configuration = this.create0().configuration();
        if (muteExceptions) {
            return DSL.using((Configuration)configuration);
        }
        final Settings newSettings = SettingsTools.clone((Settings)configuration.settings()).withRenderFormatted(Boolean.valueOf(true));
        ExecuteListenerProvider[] oldProviders = configuration.executeListenerProviders();
        ExecuteListenerProvider[] newProviders = new ExecuteListenerProvider[oldProviders.length + 1];
        System.arraycopy(oldProviders, 0, newProviders, 0, oldProviders.length);
        newProviders[oldProviders.length] = new DefaultExecuteListenerProvider((ExecuteListener)new DefaultExecuteListener(){

            public void start(ExecuteContext ctx) {
                if (!AbstractDatabase.this.initialised) {
                    DSL.using((Configuration)configuration).selectOne().fetch();
                    AbstractDatabase.this.initialised = true;
                }
            }

            public void executeStart(ExecuteContext ctx) {
                ctx.data((Object)"org.jooq.util.AbstractDatabase.watch", (Object)new StopWatch());
            }

            public void executeEnd(ExecuteContext ctx) {
                StopWatch watch = (StopWatch)ctx.data((Object)"org.jooq.util.AbstractDatabase.watch");
                if (watch.split() > TimeUnit.SECONDS.toNanos(5L)) {
                    watch.splitWarn("Slow SQL");
                    log.warn((Object)"Slow SQL", (Object)("jOOQ Meta executed a slow query (slower than 5 seconds)\n\nPlease report this bug here: https://github.com/jOOQ/jOOQ/issues/new\n\n" + this.formatted(ctx.query())), (Throwable)new SQLPerformanceWarning());
                }
            }

            public void exception(ExecuteContext ctx) {
                log.warn((Object)"SQL exception", (Object)("Exception while executing meta query: " + (ctx.sqlException() != null ? ctx.sqlException().getMessage() : (ctx.exception() != null ? ctx.exception().getMessage() : "No exception available")) + "\n\nPlease report this bug here: https://github.com/jOOQ/jOOQ/issues/new\n\n" + this.formatted(ctx.query())));
            }

            private String formatted(Query query) {
                return DSL.using((Configuration)configuration.derive(newSettings)).renderInlined((QueryPart)query);
            }

            class SQLPerformanceWarning
            extends Exception {
                SQLPerformanceWarning() {
                }
            }
        });
        return DSL.using((Configuration)configuration.derive(newProviders));
    }

    @Override
    public final boolean exists(Table<?> table) {
        Boolean result = this.exists.get(table);
        if (result == null) {
            try {
                this.create(true).selectOne().from(table).where(new Condition[]{DSL.falseCondition()}).fetch();
                result = true;
            }
            catch (DataAccessException e) {
                result = false;
            }
            this.exists.put(table, result);
        }
        return result;
    }

    @Override
    public final boolean existAll(Table<?> ... t) {
        for (Table<?> table : t) {
            if (this.exists(table)) continue;
            return false;
        }
        return true;
    }

    final Pattern pattern(String regex) {
        Pattern pattern = this.patterns.get(regex);
        if (pattern == null) {
            int flags = 0;
            ArrayList<RegexFlag> list = new ArrayList<RegexFlag>(this.getRegexFlags());
            if (list.isEmpty()) {
                list.add(RegexFlag.COMMENTS);
                list.add(RegexFlag.CASE_INSENSITIVE);
            }
            for (RegexFlag flag : list) {
                switch (flag) {
                    case CANON_EQ: {
                        flags |= 0x80;
                        break;
                    }
                    case CASE_INSENSITIVE: {
                        flags |= 2;
                        break;
                    }
                    case COMMENTS: {
                        flags |= 4;
                        break;
                    }
                    case DOTALL: {
                        flags |= 0x20;
                        break;
                    }
                    case LITERAL: {
                        flags |= 0x10;
                        break;
                    }
                    case MULTILINE: {
                        flags |= 8;
                        break;
                    }
                    case UNICODE_CASE: {
                        flags |= 0x40;
                        break;
                    }
                    case UNICODE_CHARACTER_CLASS: {
                        flags |= 0x100;
                        break;
                    }
                    case UNIX_LINES: {
                        flags |= 1;
                    }
                }
            }
            pattern = Pattern.compile(regex, flags);
            this.patterns.put(regex, pattern);
        }
        return pattern;
    }

    @Override
    public final List<CatalogDefinition> getCatalogs() {
        if (this.catalogs == null) {
            this.catalogs = new ArrayList<CatalogDefinition>();
            try {
                this.catalogs = this.getCatalogs0();
            }
            catch (Exception e) {
                log.error((Object)"Could not load catalogs", (Throwable)e);
            }
        }
        return this.catalogs;
    }

    @Override
    public final CatalogDefinition getCatalog(String inputName) {
        for (CatalogDefinition catalog : this.getCatalogs()) {
            if (!catalog.getName().equals(inputName)) continue;
            return catalog;
        }
        return null;
    }

    @Override
    public final List<SchemaDefinition> getSchemata() {
        if (this.schemata == null) {
            this.schemata = new ArrayList<SchemaDefinition>();
            try {
                this.schemata = this.getSchemata0();
            }
            catch (Exception e) {
                log.error((Object)"Could not load schemata", (Throwable)e);
            }
            Iterator<SchemaDefinition> it = this.schemata.iterator();
            while (it.hasNext()) {
                if (this.getInputSchemata().contains(it.next().getName())) continue;
                it.remove();
            }
            if (this.schemata.isEmpty()) {
                log.warn((Object)"No schemata were loaded", (Object)("Please check your connection settings, and whether your database (and your database version!) is really supported by jOOQ. Also, check the case-sensitivity in your configured <inputSchema/> elements : " + this.inputSchemata));
            }
        }
        return this.schemata;
    }

    @Override
    public final List<SchemaDefinition> getSchemata(CatalogDefinition catalog) {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (SchemaDefinition schema : this.getSchemata()) {
            if (!catalog.equals(schema.getCatalog())) continue;
            result.add(schema);
        }
        return result;
    }

    @Override
    public final SchemaDefinition getSchema(String inputName) {
        for (SchemaDefinition schema : this.getSchemata()) {
            if (!schema.getName().equals(inputName)) continue;
            return schema;
        }
        return null;
    }

    @Override
    public final List<String> getInputSchemata() {
        if (this.inputSchemata == null) {
            this.inputSchemata = new ArrayList<String>();
            if (this.configuredSchemata.size() == 1 && StringUtils.isBlank((String)this.configuredSchemata.get(0).getInputSchema())) {
                try {
                    for (SchemaDefinition schema : this.getSchemata0()) {
                        this.inputSchemata.add(schema.getName());
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Could not load schemata", (Throwable)e);
                }
            } else {
                for (Schema schema : this.configuredSchemata) {
                    this.inputSchemata.add(schema.getInputSchema());
                }
            }
        }
        return this.inputSchemata;
    }

    @Override
    @Deprecated
    public String getOutputSchema(String inputSchema) {
        for (Schema schema : this.configuredSchemata) {
            if (!inputSchema.equals(schema.getInputSchema())) continue;
            return schema.getOutputSchema();
        }
        return inputSchema;
    }

    @Override
    public final void setConfiguredSchemata(List<Schema> schemata) {
        this.configuredSchemata = schemata;
    }

    @Override
    public final void setProperties(Properties properties) {
        this.properties = properties;
    }

    public final Properties getProperties() {
        return this.properties;
    }

    @Override
    public final List<Database.Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<Database.Filter>();
        }
        return Collections.unmodifiableList(this.filters);
    }

    @Override
    public final void addFilter(Database.Filter filter) {
        this.filters.add(filter);
    }

    @Override
    public final void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    @Override
    public final String[] getExcludes() {
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        return this.excludes;
    }

    @Override
    public final void setIncludes(String[] includes) {
        this.includes = includes;
    }

    @Override
    public final String[] getIncludes() {
        if (this.includes == null) {
            this.includes = new String[0];
        }
        return this.includes;
    }

    @Override
    public final void setIncludeExcludeColumns(boolean includeExcludeColumns) {
        this.includeExcludeColumns = includeExcludeColumns;
    }

    @Override
    public final boolean getIncludeExcludeColumns() {
        return this.includeExcludeColumns;
    }

    @Override
    public final boolean getIncludeTables() {
        return this.includeTables;
    }

    @Override
    public final void setIncludeTables(boolean includeTables) {
        this.includeTables = includeTables;
    }

    @Override
    public final boolean getIncludeRoutines() {
        return this.includeRoutines;
    }

    @Override
    public final void setIncludeRoutines(boolean includeRoutines) {
        this.includeRoutines = includeRoutines;
    }

    @Override
    public final boolean getIncludePackages() {
        return this.includePackages;
    }

    @Override
    public final void setIncludePackages(boolean includePackages) {
        this.includePackages = includePackages;
    }

    @Override
    public final boolean getIncludeUDTs() {
        return this.includeUDTs;
    }

    @Override
    public final void setIncludeUDTs(boolean includeUDTs) {
        this.includeUDTs = includeUDTs;
    }

    @Override
    public final boolean getIncludeSequences() {
        return this.includeSequences;
    }

    @Override
    public final void setIncludeSequences(boolean includeSequences) {
        this.includeSequences = includeSequences;
    }

    @Override
    public final boolean getIncludePrimaryKeys() {
        return this.includePrimaryKeys;
    }

    @Override
    public final void setIncludePrimaryKeys(boolean includePrimaryKeys) {
        this.includePrimaryKeys = includePrimaryKeys;
    }

    @Override
    public final boolean getIncludeUniqueKeys() {
        return this.includeUniqueKeys;
    }

    @Override
    public final void setIncludeUniqueKeys(boolean includeUniqueKeys) {
        this.includeUniqueKeys = includeUniqueKeys;
    }

    @Override
    public final boolean getIncludeForeignKeys() {
        return this.includeForeignKeys;
    }

    @Override
    public final void setIncludeForeignKeys(boolean includeForeignKeys) {
        this.includeForeignKeys = includeForeignKeys;
    }

    @Override
    public final void setRegexFlags(List<RegexFlag> regexFlags) {
        this.regexFlags = regexFlags;
    }

    @Override
    public final List<RegexFlag> getRegexFlags() {
        if (this.regexFlags == null) {
            this.regexFlags = new ArrayList<RegexFlag>();
        }
        return this.regexFlags;
    }

    @Override
    public void setRecordVersionFields(String[] recordVersionFields) {
        this.recordVersionFields = recordVersionFields;
    }

    @Override
    public String[] getRecordVersionFields() {
        if (this.recordVersionFields == null) {
            this.recordVersionFields = new String[0];
        }
        return this.recordVersionFields;
    }

    @Override
    public void setRecordTimestampFields(String[] recordTimestampFields) {
        this.recordTimestampFields = recordTimestampFields;
    }

    @Override
    public String[] getRecordTimestampFields() {
        if (this.recordTimestampFields == null) {
            this.recordTimestampFields = new String[0];
        }
        return this.recordTimestampFields;
    }

    @Override
    public void setSyntheticPrimaryKeys(String[] syntheticPrimaryKeys) {
        this.syntheticPrimaryKeys = syntheticPrimaryKeys;
    }

    @Override
    public String[] getSyntheticPrimaryKeys() {
        if (this.syntheticPrimaryKeys == null) {
            this.syntheticPrimaryKeys = new String[0];
        }
        return this.syntheticPrimaryKeys;
    }

    @Override
    public void setOverridePrimaryKeys(String[] overridePrimaryKeys) {
        this.overridePrimaryKeys = overridePrimaryKeys;
    }

    @Override
    public String[] getOverridePrimaryKeys() {
        if (this.overridePrimaryKeys == null) {
            this.overridePrimaryKeys = new String[0];
        }
        return this.overridePrimaryKeys;
    }

    @Override
    public final void setConfiguredEnumTypes(List<EnumType> configuredEnumTypes) {
        this.configuredEnumTypes = configuredEnumTypes;
    }

    @Override
    public final List<EnumType> getConfiguredEnumTypes() {
        return this.configuredEnumTypes;
    }

    @Override
    public final void setConfiguredCustomTypes(List<CustomType> configuredCustomTypes) {
        this.configuredCustomTypes = configuredCustomTypes;
    }

    @Override
    public final List<CustomType> getConfiguredCustomTypes() {
        if (this.configuredCustomTypes == null) {
            this.configuredCustomTypes = new ArrayList<CustomType>();
        }
        return this.configuredCustomTypes;
    }

    @Override
    public final CustomType getConfiguredCustomType(String typeName) {
        if (typeName == null) {
            return null;
        }
        Iterator<CustomType> it1 = this.configuredCustomTypes.iterator();
        while (it1.hasNext()) {
            CustomType type = it1.next();
            if (type == null || type.getName() == null && type.getType() == null) {
                try {
                    StringWriter writer = new StringWriter();
                    JAXB.marshal((Object)type, (Writer)writer);
                    log.warn((Object)("Invalid custom type encountered: " + writer.toString()));
                }
                catch (Exception e) {
                    log.warn((Object)("Invalid custom type encountered: " + type));
                }
                it1.remove();
                continue;
            }
            if (!StringUtils.equals((Object)(type.getType() != null ? type.getType() : type.getName()), (Object)typeName)) continue;
            return type;
        }
        Iterator<ForcedType> it2 = this.configuredForcedTypes.iterator();
        while (it2.hasNext()) {
            ForcedType type = it2.next();
            if (StringUtils.isBlank((String)type.getName())) {
                if (StringUtils.isBlank((String)type.getUserType())) {
                    log.warn((Object)("Bad configuration for <forcedType/>. Either <name/> or <userType/> is required: " + this.toString(type)));
                    it2.remove();
                    continue;
                }
                if (StringUtils.isBlank((String)type.getBinding()) && StringUtils.isBlank((String)type.getConverter())) {
                    log.warn((Object)("Bad configuration for <forcedType/>. Either <binding/> or <converter/> is required: " + this.toString(type)));
                    it2.remove();
                    continue;
                }
            } else {
                if (!StringUtils.isBlank((String)type.getUserType())) {
                    log.warn((Object)("Bad configuration for <forcedType/>. <userType/> is not allowed when <name/> is provided: " + this.toString(type)));
                    type.setUserType(null);
                }
                if (!StringUtils.isBlank((String)type.getBinding())) {
                    log.warn((Object)("Bad configuration for <forcedType/>. <binding/> is not allowed when <name/> is provided: " + this.toString(type)));
                    type.setBinding(null);
                }
                if (!StringUtils.isBlank((String)type.getConverter())) {
                    log.warn((Object)("Bad configuration for <forcedType/>. <converter/> is not allowed when <name/> is provided: " + this.toString(type)));
                    type.setConverter(null);
                }
            }
            if (type.getUserType() == null || !StringUtils.equals((Object)type.getUserType(), (Object)typeName)) continue;
            return AbstractTypedElementDefinition.customType(this, type);
        }
        return null;
    }

    private final String toString(ForcedType type) {
        StringWriter writer = new StringWriter();
        JAXB.marshal((Object)type, (Writer)writer);
        return writer.toString();
    }

    @Override
    public final void setConfiguredForcedTypes(List<ForcedType> configuredForcedTypes) {
        this.configuredForcedTypes = configuredForcedTypes;
    }

    @Override
    public final List<ForcedType> getConfiguredForcedTypes() {
        if (this.configuredForcedTypes == null) {
            this.configuredForcedTypes = new ArrayList<ForcedType>();
        }
        return this.configuredForcedTypes;
    }

    @Override
    public final SchemaVersionProvider getSchemaVersionProvider() {
        return this.schemaVersionProvider;
    }

    @Override
    public final void setSchemaVersionProvider(SchemaVersionProvider schemaVersionProvider) {
        this.schemaVersionProvider = schemaVersionProvider;
    }

    @Override
    public final CatalogVersionProvider getCatalogVersionProvider() {
        return this.catalogVersionProvider;
    }

    @Override
    public final void setCatalogVersionProvider(CatalogVersionProvider catalogVersionProvider) {
        this.catalogVersionProvider = catalogVersionProvider;
    }

    @Override
    public final void setSupportsUnsignedTypes(boolean supportsUnsignedTypes) {
        this.supportsUnsignedTypes = supportsUnsignedTypes;
    }

    @Override
    public final boolean supportsUnsignedTypes() {
        return this.supportsUnsignedTypes;
    }

    @Override
    public final void setIgnoreProcedureReturnValues(boolean ignoreProcedureReturnValues) {
        this.ignoreProcedureReturnValues = ignoreProcedureReturnValues;
    }

    @Override
    public final boolean ignoreProcedureReturnValues() {
        return this.ignoreProcedureReturnValues;
    }

    @Override
    public final void setDateAsTimestamp(boolean dateAsTimestamp) {
        this.dateAsTimestamp = dateAsTimestamp;
    }

    @Override
    public final boolean dateAsTimestamp() {
        return this.dateAsTimestamp;
    }

    @Override
    public final void setIncludeRelations(boolean includeRelations) {
        this.includeRelations = includeRelations;
    }

    @Override
    public final boolean includeRelations() {
        return this.includeRelations;
    }

    @Override
    public final void setTableValuedFunctions(boolean tableValuedFunctions) {
        this.tableValuedFunctions = tableValuedFunctions;
    }

    @Override
    public final boolean tableValuedFunctions() {
        return this.tableValuedFunctions;
    }

    @Override
    public final List<SequenceDefinition> getSequences(SchemaDefinition schema) {
        if (this.sequences == null) {
            this.sequences = new ArrayList<SequenceDefinition>();
            if (this.getIncludeSequences()) {
                try {
                    List<SequenceDefinition> s = this.getSequences0();
                    this.sequences = this.filterExcludeInclude((List)s);
                    log.info((Object)"Sequences fetched", (Object)AbstractDatabase.fetchedSize(s, this.sequences));
                }
                catch (Exception e) {
                    log.error((Object)"Error while fetching sequences", (Throwable)e);
                }
            } else {
                log.info((Object)"Sequences excluded");
            }
        }
        if (this.sequencesBySchema == null) {
            this.sequencesBySchema = new LinkedHashMap<SchemaDefinition, List<SequenceDefinition>>();
        }
        return this.filterSchema(this.sequences, schema, this.sequencesBySchema);
    }

    @Override
    public final List<IdentityDefinition> getIdentities(SchemaDefinition schema) {
        if (this.identities == null) {
            this.identities = new ArrayList<IdentityDefinition>();
            for (SchemaDefinition s : this.getSchemata()) {
                for (TableDefinition table : this.getTables(s)) {
                    IdentityDefinition identity = table.getIdentity();
                    if (identity == null) continue;
                    this.identities.add(identity);
                }
            }
        }
        if (this.identitiesBySchema == null) {
            this.identitiesBySchema = new LinkedHashMap<SchemaDefinition, List<IdentityDefinition>>();
        }
        return this.filterSchema(this.identities, schema, this.identitiesBySchema);
    }

    @Override
    public final List<UniqueKeyDefinition> getUniqueKeys(SchemaDefinition schema) {
        if (this.uniqueKeys == null) {
            this.uniqueKeys = new ArrayList<UniqueKeyDefinition>();
            if (this.getIncludeUniqueKeys()) {
                for (SchemaDefinition s : this.getSchemata()) {
                    for (TableDefinition table : this.getTables(s)) {
                        for (UniqueKeyDefinition uniqueKey : table.getUniqueKeys()) {
                            this.uniqueKeys.add(uniqueKey);
                        }
                    }
                }
            }
        }
        if (this.uniqueKeysBySchema == null) {
            this.uniqueKeysBySchema = new LinkedHashMap<SchemaDefinition, List<UniqueKeyDefinition>>();
        }
        return this.filterSchema(this.uniqueKeys, schema, this.uniqueKeysBySchema);
    }

    @Override
    public final List<ForeignKeyDefinition> getForeignKeys(SchemaDefinition schema) {
        if (this.foreignKeys == null) {
            this.foreignKeys = new ArrayList<ForeignKeyDefinition>();
            if (this.getIncludeForeignKeys()) {
                for (SchemaDefinition s : this.getSchemata()) {
                    for (TableDefinition table : this.getTables(s)) {
                        for (ForeignKeyDefinition foreignKey : table.getForeignKeys()) {
                            this.foreignKeys.add(foreignKey);
                        }
                    }
                }
            }
        }
        if (this.foreignKeysBySchema == null) {
            this.foreignKeysBySchema = new LinkedHashMap<SchemaDefinition, List<ForeignKeyDefinition>>();
        }
        return this.filterSchema(this.foreignKeys, schema, this.foreignKeysBySchema);
    }

    @Override
    public final List<CheckConstraintDefinition> getCheckConstraints(SchemaDefinition schema) {
        if (this.checkConstraints == null) {
            this.checkConstraints = new ArrayList<CheckConstraintDefinition>();
            for (SchemaDefinition s : this.getSchemata()) {
                for (TableDefinition table : this.getTables(s)) {
                    for (CheckConstraintDefinition checkConstraint : table.getCheckConstraints()) {
                        this.checkConstraints.add(checkConstraint);
                    }
                }
            }
        }
        if (this.checkConstraintsBySchema == null) {
            this.checkConstraintsBySchema = new LinkedHashMap<SchemaDefinition, List<CheckConstraintDefinition>>();
        }
        return this.filterSchema(this.checkConstraints, schema, this.checkConstraintsBySchema);
    }

    @Override
    public final List<TableDefinition> getTables(SchemaDefinition schema) {
        if (this.tables == null) {
            this.tables = new ArrayList<TableDefinition>();
            if (this.getIncludeTables()) {
                try {
                    List<TableDefinition> t = this.getTables0();
                    this.tables = this.filterExcludeInclude((List)t);
                    log.info((Object)"Tables fetched", (Object)AbstractDatabase.fetchedSize(t, this.tables));
                }
                catch (Exception e) {
                    log.error((Object)"Error while fetching tables", (Throwable)e);
                }
            } else {
                log.info((Object)"Tables excluded");
            }
        }
        if (this.tablesBySchema == null) {
            this.tablesBySchema = new LinkedHashMap<SchemaDefinition, List<TableDefinition>>();
        }
        return this.filterSchema(this.tables, schema, this.tablesBySchema);
    }

    @Override
    public final TableDefinition getTable(SchemaDefinition schema, String name) {
        return this.getTable(schema, name, false);
    }

    @Override
    public final TableDefinition getTable(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getTables(schema), name, ignoreCase);
    }

    @Override
    public final List<EnumDefinition> getEnums(SchemaDefinition schema) {
        if (this.enums == null) {
            this.enums = new ArrayList<EnumDefinition>();
            try {
                List<EnumDefinition> e = this.getEnums0();
                this.enums = this.filterExcludeInclude((List)e);
                this.enums.addAll(this.getConfiguredEnums());
                log.info((Object)"Enums fetched", (Object)AbstractDatabase.fetchedSize(e, this.enums));
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching enums", (Throwable)e);
            }
        }
        if (this.enumsBySchema == null) {
            this.enumsBySchema = new LinkedHashMap<SchemaDefinition, List<EnumDefinition>>();
        }
        return this.filterSchema(this.enums, schema, this.enumsBySchema);
    }

    private final List<EnumDefinition> getConfiguredEnums() {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        for (EnumType enumType : this.configuredEnumTypes) {
            String name = enumType.getName();
            DefaultEnumDefinition e = new DefaultEnumDefinition(this.getSchemata().get(0), name, null, true);
            String literals = enumType.getLiterals();
            try {
                CSVReader reader = new CSVReader((Reader)new StringReader(literals));
                e.addLiterals(reader.readNext());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            result.add(e);
        }
        return result;
    }

    @Override
    public final ForcedType getConfiguredForcedType(Definition definition) {
        return this.getConfiguredForcedType(definition, null);
    }

    @Override
    public final ForcedType getConfiguredForcedType(Definition definition, DataTypeDefinition definedType) {
        for (ForcedType forcedType : this.getConfiguredForcedTypes()) {
            Pattern p;
            String expression = forcedType.getExpression();
            if (forcedType.getExpressions() != null) {
                expression = forcedType.getExpressions();
                log.warn((Object)"DEPRECATED", (Object)"The <expressions/> element in <forcedType/> is deprecated. Use <expression/> instead");
            }
            String types = forcedType.getTypes();
            if (expression != null && !(p = this.pattern(expression)).matcher(definition.getName()).matches() && !p.matcher(definition.getQualifiedName()).matches() || types != null && definedType != null && !(p = this.pattern(types)).matcher(definedType.getType()).matches() && (definedType.getLength() == 0 || !p.matcher(definedType.getType() + "(" + definedType.getLength() + ")").matches()) && (definedType.getScale() != 0 || !p.matcher(definedType.getType() + "(" + definedType.getPrecision() + ")").matches()) && !p.matcher(definedType.getType() + "(" + definedType.getPrecision() + "," + definedType.getScale() + ")").matches() && !p.matcher(definedType.getType() + "(" + definedType.getPrecision() + ", " + definedType.getScale() + ")").matches()) continue;
            return forcedType;
        }
        return null;
    }

    @Override
    public final EnumDefinition getEnum(SchemaDefinition schema, String name) {
        return this.getEnum(schema, name, false);
    }

    @Override
    public final EnumDefinition getEnum(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getEnums(schema), name, ignoreCase);
    }

    @Override
    public final List<DomainDefinition> getDomains(SchemaDefinition schema) {
        if (this.domains == null) {
            this.domains = new ArrayList<DomainDefinition>();
            try {
                List<DomainDefinition> e = this.getDomains0();
                this.domains = this.filterExcludeInclude((List)e);
                log.info((Object)"Domains fetched", (Object)AbstractDatabase.fetchedSize(e, this.domains));
            }
            catch (Exception e) {
                log.error((Object)"Error while fetching domains", (Throwable)e);
            }
        }
        return this.domains;
    }

    @Override
    public final DomainDefinition getDomain(SchemaDefinition schema, String name) {
        return this.getDomain(schema, name, false);
    }

    @Override
    public final DomainDefinition getDomain(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getDomains(schema), name, ignoreCase);
    }

    @Override
    public final List<ArrayDefinition> getArrays(SchemaDefinition schema) {
        if (this.arrays == null) {
            this.arrays = new ArrayList<ArrayDefinition>();
            if (this.getIncludeUDTs()) {
                try {
                    List<ArrayDefinition> a = this.getArrays0();
                    this.arrays = this.filterExcludeInclude((List)a);
                    log.info((Object)"ARRAYs fetched", (Object)AbstractDatabase.fetchedSize(a, this.arrays));
                }
                catch (Exception e) {
                    log.error((Object)"Error while fetching ARRAYS", (Throwable)e);
                }
            } else {
                log.info((Object)"ARRAYs excluded");
            }
        }
        if (this.arraysBySchema == null) {
            this.arraysBySchema = new LinkedHashMap<SchemaDefinition, List<ArrayDefinition>>();
        }
        return this.filterSchema(this.arrays, schema, this.arraysBySchema);
    }

    @Override
    public final ArrayDefinition getArray(SchemaDefinition schema, String name) {
        return this.getArray(schema, name, false);
    }

    @Override
    public final ArrayDefinition getArray(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getArrays(schema), name, ignoreCase);
    }

    @Override
    public final List<UDTDefinition> getUDTs(SchemaDefinition schema) {
        if (this.udts == null) {
            this.udts = new ArrayList<UDTDefinition>();
            if (this.getIncludeUDTs()) {
                try {
                    List<UDTDefinition> u = this.getUDTs0();
                    this.udts = this.filterExcludeInclude((List)u);
                    log.info((Object)"UDTs fetched", (Object)AbstractDatabase.fetchedSize(u, this.udts));
                }
                catch (Exception e) {
                    log.error((Object)"Error while fetching udts", (Throwable)e);
                }
            } else {
                log.info((Object)"UDTs excluded");
            }
        }
        if (this.udtsBySchema == null) {
            this.udtsBySchema = new LinkedHashMap<SchemaDefinition, List<UDTDefinition>>();
        }
        return this.filterSchema(this.udts, schema, this.udtsBySchema);
    }

    @Override
    public final UDTDefinition getUDT(SchemaDefinition schema, String name) {
        return this.getUDT(schema, name, false);
    }

    @Override
    public final UDTDefinition getUDT(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getUDTs(schema), name, ignoreCase);
    }

    @Override
    public final Relations getRelations() {
        if (this.relations == null) {
            this.relations = new DefaultRelations();
            if (this.includeRelations) {
                try {
                    this.relations = this.getRelations0();
                }
                catch (Exception e) {
                    log.error((Object)"Error while fetching relations", (Throwable)e);
                }
            }
        }
        return this.relations;
    }

    @Override
    public final List<RoutineDefinition> getRoutines(SchemaDefinition schema) {
        if (this.routines == null) {
            this.routines = new ArrayList<RoutineDefinition>();
            if (this.getIncludeRoutines()) {
                try {
                    List<RoutineDefinition> r = this.getRoutines0();
                    this.routines = this.filterExcludeInclude((List)r);
                    log.info((Object)"Routines fetched", (Object)AbstractDatabase.fetchedSize(r, this.routines));
                }
                catch (Exception e) {
                    log.error((Object)"Error while fetching functions", (Throwable)e);
                }
            } else {
                log.info((Object)"Routines excluded");
            }
        }
        if (this.routinesBySchema == null) {
            this.routinesBySchema = new LinkedHashMap<SchemaDefinition, List<RoutineDefinition>>();
        }
        return this.filterSchema(this.routines, schema, this.routinesBySchema);
    }

    @Override
    public final List<PackageDefinition> getPackages(SchemaDefinition schema) {
        if (this.packages == null) {
            this.packages = new ArrayList<PackageDefinition>();
            if (this.getIncludePackages()) {
                try {
                    List<PackageDefinition> p = this.getPackages0();
                    this.packages = this.filterExcludeInclude((List)p);
                    log.info((Object)"Packages fetched", (Object)AbstractDatabase.fetchedSize(p, this.packages));
                }
                catch (Exception e) {
                    log.error((Object)"Error while fetching packages", (Throwable)e);
                }
            } else {
                log.info((Object)"Packages excluded");
            }
        }
        if (this.packagesBySchema == null) {
            this.packagesBySchema = new LinkedHashMap<SchemaDefinition, List<PackageDefinition>>();
        }
        return this.filterSchema(this.packages, schema, this.packagesBySchema);
    }

    protected static final <D extends Definition> D getDefinition(List<D> definitions, String name, boolean ignoreCase) {
        for (Definition definition : definitions) {
            if ((!ignoreCase || !definition.getName().equalsIgnoreCase(name)) && (ignoreCase || !definition.getName().equals(name))) continue;
            return (D)definition;
        }
        return null;
    }

    protected final <T extends Definition> List<T> filterSchema(List<T> definitions, SchemaDefinition schema, Map<SchemaDefinition, List<T>> cache) {
        List<T> result = cache.get(schema);
        if (result == null) {
            result = this.filterSchema(definitions, schema);
            cache.put(schema, result);
        }
        return result;
    }

    protected final <T extends Definition> List<T> filterSchema(List<T> definitions, SchemaDefinition schema) {
        if (schema == null) {
            return definitions;
        }
        ArrayList<Definition> result = new ArrayList<Definition>();
        for (Definition definition : definitions) {
            if (!definition.getSchema().equals(schema)) continue;
            result.add(definition);
        }
        return result;
    }

    public final <T extends Definition> List<T> filterExcludeInclude(List<T> definitions) {
        return this.filterExcludeInclude(definitions, this.excludes, this.includes, this.filters);
    }

    protected final <T extends Definition> List<T> filterExcludeInclude(List<T> definitions, String[] e, String[] i, List<Database.Filter> f) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        block0: for (Definition definition : definitions) {
            Pattern p;
            if (e != null) {
                for (String exclude : e) {
                    p = this.pattern(exclude);
                    if (exclude == null || !p.matcher(definition.getName()).matches() && !p.matcher(definition.getQualifiedName()).matches()) continue;
                    if (!log.isDebugEnabled()) continue block0;
                    log.debug((Object)"Exclude", (Object)("Excluding " + definition.getQualifiedName() + " because of pattern " + exclude));
                    continue block0;
                }
            }
            if (i == null) continue;
            for (String include : i) {
                p = this.pattern(include);
                if (include == null || !p.matcher(definition.getName()).matches() && !p.matcher(definition.getQualifiedName()).matches()) continue;
                for (Database.Filter filter : f) {
                    if (!filter.exclude(definition)) continue;
                    if (!log.isDebugEnabled()) continue block0;
                    log.debug((Object)"Exclude", (Object)("Excluding " + definition.getQualifiedName() + " because of filter " + filter));
                    continue block0;
                }
                result.add(definition);
                if (!log.isDebugEnabled()) continue block0;
                log.debug((Object)"Include", (Object)("Including " + definition.getQualifiedName() + " because of pattern " + include));
                continue block0;
            }
        }
        return result;
    }

    protected final Relations getRelations0() {
        DefaultRelations result = new DefaultRelations();
        try {
            this.loadPrimaryKeys(result);
        }
        catch (Exception e) {
            log.error((Object)"Error while fetching primary keys", (Throwable)e);
        }
        try {
            this.loadUniqueKeys(result);
        }
        catch (Exception e) {
            log.error((Object)"Error while fetching unique keys", (Throwable)e);
        }
        try {
            this.loadForeignKeys(result);
        }
        catch (Exception e) {
            log.error((Object)"Error while fetching foreign keys", (Throwable)e);
        }
        try {
            this.loadCheckConstraints(result);
        }
        catch (Exception e) {
            log.error((Object)"Error while fetching check constraints", (Throwable)e);
        }
        try {
            this.syntheticPrimaryKeys(result);
        }
        catch (Exception e) {
            log.error((Object)"Error while generating synthetic primary keys", (Throwable)e);
        }
        try {
            this.overridePrimaryKeys(result);
        }
        catch (Exception e) {
            log.error((Object)"Error while overriding primary keys", (Throwable)e);
        }
        return result;
    }

    @Override
    public final boolean isArrayType(String dataType) {
        switch (this.getDialect().family()) {
            case POSTGRES: 
            case H2: {
                return "ARRAY".equals(dataType);
            }
            case HSQLDB: {
                return dataType.endsWith(" ARRAY");
            }
        }
        return false;
    }

    protected static final String fetchedSize(List<?> fetched, List<?> included) {
        return fetched.size() + " (" + included.size() + " included, " + (fetched.size() - included.size()) + " excluded)";
    }

    private final void syntheticPrimaryKeys(DefaultRelations r) {
        ArrayList<DefaultUniqueKeyDefinition> syntheticKeys = new ArrayList<DefaultUniqueKeyDefinition>();
        for (SchemaDefinition schemaDefinition : this.getSchemata()) {
            for (TableDefinition table : schemaDefinition.getTables()) {
                List<ColumnDefinition> columns = this.filterExcludeInclude(table.getColumns(), null, this.getSyntheticPrimaryKeys(), this.filters);
                if (columns.isEmpty()) continue;
                DefaultUniqueKeyDefinition syntheticKey = new DefaultUniqueKeyDefinition(schemaDefinition, "SYNTHETIC_PK_" + table.getName(), table, true);
                syntheticKey.getKeyColumns().addAll(columns);
                syntheticKeys.add(syntheticKey);
            }
        }
        log.info((Object)"Synthetic primary keys", (Object)AbstractDatabase.fetchedSize(syntheticKeys, syntheticKeys));
        for (UniqueKeyDefinition uniqueKeyDefinition : syntheticKeys) {
            r.overridePrimaryKey(uniqueKeyDefinition);
        }
    }

    private final void overridePrimaryKeys(DefaultRelations r) {
        List<UniqueKeyDefinition> allKeys = r.getUniqueKeys();
        List<UniqueKeyDefinition> filteredKeys = this.filterExcludeInclude(allKeys, null, this.overridePrimaryKeys, this.filters);
        log.info((Object)"Overriding primary keys", (Object)AbstractDatabase.fetchedSize(allKeys, filteredKeys));
        for (UniqueKeyDefinition key : filteredKeys) {
            r.overridePrimaryKey(key);
        }
    }

    protected abstract DSLContext create0();

    protected abstract void loadPrimaryKeys(DefaultRelations var1) throws SQLException;

    protected abstract void loadUniqueKeys(DefaultRelations var1) throws SQLException;

    protected abstract void loadForeignKeys(DefaultRelations var1) throws SQLException;

    protected abstract void loadCheckConstraints(DefaultRelations var1) throws SQLException;

    protected abstract List<CatalogDefinition> getCatalogs0() throws SQLException;

    protected abstract List<SchemaDefinition> getSchemata0() throws SQLException;

    protected abstract List<SequenceDefinition> getSequences0() throws SQLException;

    protected abstract List<TableDefinition> getTables0() throws SQLException;

    protected abstract List<RoutineDefinition> getRoutines0() throws SQLException;

    protected abstract List<PackageDefinition> getPackages0() throws SQLException;

    protected abstract List<EnumDefinition> getEnums0() throws SQLException;

    protected abstract List<DomainDefinition> getDomains0() throws SQLException;

    protected abstract List<UDTDefinition> getUDTs0() throws SQLException;

    protected abstract List<ArrayDefinition> getArrays0() throws SQLException;

    protected final DataTypeDefinition getDataTypeForMAX_VAL(SchemaDefinition schema, BigInteger value) {
        DefaultDataTypeDefinition type = BigInteger.valueOf(127L).compareTo(value) >= 0 ? new DefaultDataTypeDefinition((Database)this, schema, SQLDataType.NUMERIC.getTypeName(), (Number)0, (Number)2, (Number)0, (Boolean)false, (String)null) : (BigInteger.valueOf(32767L).compareTo(value) >= 0 ? new DefaultDataTypeDefinition((Database)this, schema, SQLDataType.NUMERIC.getTypeName(), (Number)0, (Number)4, (Number)0, (Boolean)false, (String)null) : (BigInteger.valueOf(Integer.MAX_VALUE).compareTo(value) >= 0 ? new DefaultDataTypeDefinition((Database)this, schema, SQLDataType.NUMERIC.getTypeName(), (Number)0, (Number)9, (Number)0, (Boolean)false, (String)null) : (BigInteger.valueOf(Long.MAX_VALUE).compareTo(value) >= 0 ? new DefaultDataTypeDefinition((Database)this, schema, SQLDataType.NUMERIC.getTypeName(), (Number)0, (Number)18, (Number)0, (Boolean)false, (String)null) : new DefaultDataTypeDefinition((Database)this, schema, SQLDataType.NUMERIC.getTypeName(), (Number)0, (Number)38, (Number)0, (Boolean)false, (String)null))));
        return type;
    }
}

