/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.CsvParserFactory;
import org.junit.jupiter.params.provider.CsvParsingException;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.shadow.com.univocity.parsers.csv.CsvParser;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.UnrecoverableExceptions;

class CsvArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<CsvSource> {
    private static final String LINE_SEPARATOR = "\n";
    private CsvSource annotation;
    private Set<String> nullValues;
    private CsvParser csvParser;

    CsvArgumentsProvider() {
    }

    @Override
    public void accept(CsvSource annotation) {
        this.annotation = annotation;
        this.nullValues = CollectionUtils.toSet((Object[])annotation.nullValues());
        this.csvParser = CsvParserFactory.createParserFor(annotation);
    }

    @Override
    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        AtomicLong index = new AtomicLong(0L);
        return Arrays.stream(this.annotation.value()).map(line -> this.parseLine(index.getAndIncrement(), (String)line)).map(Arguments::of);
    }

    private String[] parseLine(long index, String line) {
        String[] parsedLine = null;
        try {
            parsedLine = this.csvParser.parseLine(line + LINE_SEPARATOR);
            if (parsedLine != null && !this.nullValues.isEmpty()) {
                for (int i = 0; i < parsedLine.length; ++i) {
                    if (!this.nullValues.contains(parsedLine[i])) continue;
                    parsedLine[i] = null;
                }
            }
        }
        catch (Throwable throwable) {
            CsvArgumentsProvider.handleCsvException(throwable, this.annotation);
        }
        Preconditions.notNull(parsedLine, () -> "Line at index " + index + " contains invalid CSV: \"" + line + "\"");
        return parsedLine;
    }

    static void handleCsvException(Throwable throwable, Annotation annotation) {
        UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)throwable);
        if (throwable instanceof PreconditionViolationException) {
            throw (PreconditionViolationException)throwable;
        }
        throw new CsvParsingException("Failed to parse CSV input configured via " + annotation, throwable);
    }
}

