/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.Locale;
import org.apiguardian.api.API;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.support.hierarchical.DefaultParallelExecutionConfigurationStrategy;
import org.junit.platform.engine.support.hierarchical.ForkJoinPoolHierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.ParallelExecutionConfiguration;
import org.junit.platform.engine.support.hierarchical.WorkerThreadPoolHierarchicalTestExecutorService;

@API(status=API.Status.MAINTAINED, since="6.1")
public final class ParallelHierarchicalTestExecutorServiceFactory {
    public static final String EXECUTOR_SERVICE_PROPERTY_NAME = "executor-service";

    public static HierarchicalTestExecutorService create(ConfigurationParameters configurationParameters) {
        ParallelExecutorServiceType type = configurationParameters.get(EXECUTOR_SERVICE_PROPERTY_NAME, ParallelExecutorServiceType::parse).orElse(ParallelExecutorServiceType.FORK_JOIN_POOL);
        ParallelExecutionConfiguration configuration = DefaultParallelExecutionConfigurationStrategy.toConfiguration(configurationParameters);
        return ParallelHierarchicalTestExecutorServiceFactory.create(type, configuration);
    }

    public static HierarchicalTestExecutorService create(ParallelExecutorServiceType executorServiceType, ParallelExecutionConfiguration configuration) {
        return switch (executorServiceType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> new ForkJoinPoolHierarchicalTestExecutorService(configuration, ForkJoinPoolHierarchicalTestExecutorService.TaskEventListener.NOOP);
            case 1 -> new WorkerThreadPoolHierarchicalTestExecutorService(configuration);
        };
    }

    private ParallelHierarchicalTestExecutorServiceFactory() {
    }

    @API(status=API.Status.MAINTAINED, since="6.1")
    public static enum ParallelExecutorServiceType {
        FORK_JOIN_POOL,
        WORKER_THREAD_POOL;


        private static ParallelExecutorServiceType parse(String value) {
            return ParallelExecutorServiceType.valueOf(value.toUpperCase(Locale.ROOT));
        }
    }
}

