/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.util;

import hudson.scm.RevisionParameterAction;
import hudson.scm.SubversionSCM;
import java.util.Date;
import org.tmatesoft.svn.core.wc.SVNRevision;

public final class RevisionUtil {
    static final char AT_SYMBOL = '@';

    private RevisionUtil() {
    }

    public static SVNRevision getRevision(SubversionSCM.ModuleLocation location, RevisionParameterAction revisionParameterAction, SubversionSCM.RevisionPolicy revisionPolicy, Date queueTime, Date buildTime) {
        SVNRevision revision;
        int idx = location.getOriginRemote().lastIndexOf(64);
        if (idx > 0) {
            String n = location.getOriginRemote().substring(idx + 1);
            return SVNRevision.parse((String)n);
        }
        if (revisionParameterAction != null && (revision = revisionParameterAction.getRevision(location.getURL())) != null) {
            return revisionParameterAction.getRevision(location.getURL());
        }
        switch (revisionPolicy) {
            case QUEUE_TIME: {
                return SVNRevision.create((Date)queueTime);
            }
            case BUILD_TIME: {
                return SVNRevision.create((Date)buildTime);
            }
            case HEAD: {
                return SVNRevision.HEAD;
            }
        }
        throw new IllegalArgumentException("Unknown revision policy value:" + revisionPolicy.name());
    }
}

