/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.minicluster.cli;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.kitesdk.minicluster.MiniCluster;
import org.kitesdk.minicluster.cli.Command;
import org.slf4j.Logger;

@Parameters(commandDescription="Run a minicluster of services. The following service short names exist: hdfs, zk, hbase, hive, flume.")
public class RunCommand
implements Command {
    private static final Map<String, String> simpleServiceNameMap = Maps.newHashMap();
    private final Logger console;
    private final Configuration conf;
    @Parameter(description="<service names>")
    public List<String> services = new ArrayList<String>();
    @Parameter(names={"-d", "--work-dir"}, description="The base directory to store mini cluster data in. Defaults to /tmp/kite-minicluster.")
    @SuppressWarnings(value={"UWF_NULL_FIELD"}, justification="Field set by JCommander")
    String workDir = "/tmp/kite-minicluster";
    @Parameter(names={"-b", "--bind"}, description="The IP address for all mini cluster services to bind to. Defaults to 127.0.0.1.")
    @SuppressWarnings(value={"UWF_NULL_FIELD"}, justification="Field set by JCommander")
    String bindIP = "127.0.0.1";
    @Parameter(names={"-c", "--clean"}, description="Clean the mini cluster data directory before starting.")
    boolean clean = false;
    @Parameter(names={"--hdfs-namenode-rpc-port"}, description="The namenode RPC port. Defaults to 8020.")
    int namenodeRpcPort = 8020;
    @Parameter(names={"--zk-port"}, description="The zookeeper port. Defaults to 2828.")
    int zkPort = 2828;
    @Parameter(names={"--hive-metastore-port"}, description="The Hive Metastore port. Defaults to 9083.")
    int hiveMetastorePort = 9083;
    @Parameter(names={"--hive-server-port"}, description="The Hive Server port. Defaults to 10000.")
    int hiveServerPort = 10000;
    @Parameter(names={"--flume-configuration"}, description="The Flume configuration file.")
    String flumeConfiguration;
    @Parameter(names={"--flume-agent-name"}, description="The name of the Flume agent.")
    String flumeAgentName;
    @DynamicParameter(names={"-D"}, description="Service specific configs go here. These configs are passed through to the ServiceConfig using the key/value specified here.")
    private Map<String, String> serviceParams = new HashMap<String, String>();

    public RunCommand(Logger console, Configuration conf) {
        this.console = console;
        this.conf = conf;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.services.size() > 0 ? 1 : 0) != 0, (Object)"At least one service must be specified.");
        Preconditions.checkArgument((this.workDir != null ? 1 : 0) != 0, (Object)"A valid work dir is required.");
        MiniCluster.Builder builder = new MiniCluster.Builder().workDir(this.workDir).clean(this.clean).hadoopConf(this.conf).bindIP(this.bindIP).namenodeRpcPort(this.namenodeRpcPort).zkPort(this.zkPort).hiveMetastorePort(this.hiveMetastorePort).hiveServerPort(this.hiveServerPort);
        if (this.flumeConfiguration != null) {
            builder.flumeConfiguration(this.flumeConfiguration);
        }
        if (this.flumeAgentName != null) {
            builder.flumeAgentName(this.flumeAgentName);
        }
        for (String string : this.services) {
            void var3_3;
            if (simpleServiceNameMap.containsKey(string)) {
                String string2 = simpleServiceNameMap.get(string);
            }
            try {
                builder.addService(Class.forName((String)var3_3));
            }
            catch (ClassNotFoundException e) {
                this.console.error("Unknown service class specified: " + (String)var3_3);
                throw new RuntimeException(e);
            }
        }
        for (Map.Entry entry : this.serviceParams.entrySet()) {
            builder.setServiceConfig((String)entry.getKey(), (String)entry.getValue());
        }
        final MiniCluster miniCluster = builder.build();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Thread exitThread = new Thread(){

            @Override
            public void run() {
                try {
                    miniCluster.stop();
                }
                catch (Throwable e) {
                    RunCommand.this.console.error("Error stopping mini cluster. Exiting anyways...", e);
                }
                countDownLatch.countDown();
            }
        };
        Runtime.getRuntime().addShutdownHook(exitThread);
        try {
            miniCluster.start();
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return 1;
        }
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Run a mini HDFS cluster:", "hdfs", "# Run an HBase cluster that forces everything to listen on IP 10.0.0.1:", "hdfs zk hbase -b 10.0.0.1", "# Run an HBase cluster, cleaning out any data from previous cluster runs:", "hdfs zk hbase -d /tmp/kite-minicluster -c", "# Run an HBase cluster with custom ports using the service configs:", "hdfs zk hbase -Dhbase-master-port=63000 -Dhbase-regionserver-port=63020"});
    }

    static {
        simpleServiceNameMap.put("hdfs", "org.kitesdk.minicluster.HdfsService");
        simpleServiceNameMap.put("zk", "org.kitesdk.minicluster.ZookeeperService");
        simpleServiceNameMap.put("flume", "org.kitesdk.minicluster.FlumeService");
        simpleServiceNameMap.put("hbase", "org.kitesdk.minicluster.HBaseService");
        simpleServiceNameMap.put("hive", "org.kitesdk.minicluster.HiveService");
    }
}

