/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.database;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.spi.PersistenceUnitTransactionType;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.ext.hibernate.database.HibernateGenericDialect;
import liquibase.logging.LogService;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;

public class HibernateEjb3Database
extends HibernateDatabase {
    protected EntityManagerFactory entityManagerFactory;

    public String getShortName() {
        return "hibernateEjb3";
    }

    protected String getDefaultDatabaseProductName() {
        return "Hibernate EJB3";
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return conn.getURL().startsWith("hibernate:ejb3:");
    }

    @Override
    protected Metadata buildMetadataFromPath() throws DatabaseException {
        EntityManagerFactoryBuilderImpl builder = this.createEntityManagerFactoryBuilder();
        this.entityManagerFactory = builder.build();
        MetadataImplementor metadata = builder.getMetadata();
        String dialectString = this.findDialectName();
        if (dialectString != null) {
            try {
                this.dialect = (Dialect)Class.forName(dialectString).newInstance();
                LOG.info("Using dialect " + dialectString);
            }
            catch (Exception e) {
                throw new DatabaseException((Throwable)e);
            }
        } else {
            LOG.info("Could not determine hibernate dialect, using HibernateGenericDialect");
            this.dialect = new HibernateGenericDialect();
        }
        return metadata;
    }

    protected EntityManagerFactoryBuilderImpl createEntityManagerFactoryBuilder() {
        MyHibernatePersistenceProvider persistenceProvider = new MyHibernatePersistenceProvider();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.cache.use_second_level_cache", Boolean.FALSE.toString());
        EntityManagerFactoryBuilderImpl builder = (EntityManagerFactoryBuilderImpl)persistenceProvider.getEntityManagerFactoryBuilderOrNull(this.getHibernateConnection().getPath(), properties, null);
        return builder;
    }

    @Override
    public String getProperty(String name) {
        String property = null;
        if (this.entityManagerFactory != null) {
            property = (String)this.entityManagerFactory.getProperties().get(name);
        }
        if (property == null) {
            return super.getProperty(name);
        }
        return property;
    }

    @Override
    protected String findDialectName() {
        String dialectName = super.findDialectName();
        if (dialectName != null) {
            return dialectName;
        }
        return (String)this.entityManagerFactory.getProperties().get("hibernate.dialect");
    }

    @Override
    protected void configureSources(MetadataSources sources) throws DatabaseException {
        Package[] packages;
        for (ManagedType managedType : this.entityManagerFactory.getMetamodel().getManagedTypes()) {
            Class javaType = managedType.getJavaType();
            if (javaType == null) continue;
            sources.addAnnotatedClass(javaType);
        }
        for (Package p : packages = Package.getPackages()) {
            sources.addPackage(p);
        }
    }

    private static class MyHibernatePersistenceProvider
    extends HibernatePersistenceProvider {
        private MyHibernatePersistenceProvider() {
        }

        private void setField(final Object obj, String fieldName, final Object value) throws Exception {
            final Field declaredField = obj.getClass().getDeclaredField(fieldName);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    boolean wasAccessible = declaredField.isAccessible();
                    try {
                        declaredField.setAccessible(true);
                        declaredField.set(obj, value);
                        Object var2_2 = null;
                        return var2_2;
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Cannot invoke method get", ex);
                    }
                    finally {
                        declaredField.setAccessible(wasAccessible);
                    }
                }
            });
        }

        protected EntityManagerFactoryBuilder getEntityManagerFactoryBuilderOrNull(String persistenceUnitName, Map properties, ClassLoader providedClassLoader) {
            return super.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, properties, providedClassLoader);
        }

        protected EntityManagerFactoryBuilder getEntityManagerFactoryBuilder(PersistenceUnitDescriptor persistenceUnitDescriptor, Map integration, ClassLoader providedClassLoader) {
            try {
                this.setField(persistenceUnitDescriptor, "jtaDataSource", null);
                this.setField(persistenceUnitDescriptor, "transactionType", PersistenceUnitTransactionType.RESOURCE_LOCAL);
            }
            catch (Exception ex) {
                LogService.getLog(HibernateEjb3Database.class).severe(null, (Throwable)ex);
            }
            return super.getEntityManagerFactoryBuilder(persistenceUnitDescriptor, integration, providedClassLoader);
        }
    }
}

