/*
 * Decompiled with CFR 0.152.
 */
package liquibase.precondition.core;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.precondition.AbstractPrecondition;

public class ObjectQuotingStrategyPrecondition
extends AbstractPrecondition {
    private ObjectQuotingStrategy strategy;

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }

    @Override
    public String getName() {
        return "expectedQuotingStrategy";
    }

    @Override
    public Warnings warn(Database database) {
        return new Warnings();
    }

    @Override
    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    @Override
    public void check(Database database, DatabaseChangeLog changeLog, ChangeSet changeSet, ChangeExecListener changeExecListener) throws PreconditionFailedException, PreconditionErrorException {
        try {
            if (changeLog.getObjectQuotingStrategy() != this.strategy) {
                throw new PreconditionFailedException("Quoting strategy Precondition failed: expected " + (Object)((Object)this.strategy) + ", got " + (Object)((Object)changeSet.getObjectQuotingStrategy()), changeLog, this);
            }
        }
        catch (PreconditionFailedException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new PreconditionErrorException(e3, changeLog, this);
        }
    }

    public void setStrategy(String strategy) {
        this.strategy = ObjectQuotingStrategy.valueOf(strategy);
    }
}

