/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.output;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Column;
import liquibase.structure.core.Data;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Schema;
import liquibase.structure.core.UniqueConstraint;
import liquibase.util.StringUtils;

public class StandardObjectChangeFilter
implements ObjectChangeFilter {
    private FilterType filterType;
    private List<Filter> filters = new ArrayList<Filter>();
    private boolean catalogOrSchemaFilter;

    public StandardObjectChangeFilter(FilterType type, String filter) {
        this.filterType = type;
        this.parseFilter(filter);
    }

    protected void parseFilter(String filter) {
        if ((filter = StringUtils.trimToNull(filter)) == null) {
            return;
        }
        for (String subfilter : filter.split("\\s*,\\s*")) {
            String[] split = subfilter.split(":");
            if (split.length == 1) {
                this.filters.add(new Filter(null, Pattern.compile(split[0])));
                continue;
            }
            String className = StringUtils.upperCaseFirst(split[0]);
            className = "liquibase.structure.core." + className;
            try {
                Class<DatabaseObject> clazz = Class.forName(className);
                this.filters.add(new Filter(clazz, Pattern.compile(split[1])));
                this.catalogOrSchemaFilter |= "Catalog".equals(className) || "Schema".equals(className);
            }
            catch (ClassNotFoundException e) {
                throw new UnexpectedLiquibaseException(e);
            }
        }
    }

    @Override
    public boolean includeMissing(DatabaseObject object, Database referenceDatabase, Database comparisionDatabase) {
        return this.include(object);
    }

    @Override
    public boolean includeUnexpected(DatabaseObject object, Database referenceDatabase, Database comparisionDatabase) {
        return this.include(object);
    }

    @Override
    public boolean includeChanged(DatabaseObject object, ObjectDifferences differences, Database referenceDatabase, Database comparisionDatabase) {
        return this.include(object);
    }

    @Override
    public boolean include(DatabaseObject object) {
        if (this.filters.isEmpty()) {
            return true;
        }
        for (Filter filter : this.filters) {
            if (!filter.matches(object)) continue;
            if (this.filterType == FilterType.INCLUDE) {
                return true;
            }
            if (this.filterType != FilterType.EXCLUDE) continue;
            return false;
        }
        return this.filterType == FilterType.EXCLUDE || (object instanceof Catalog || object instanceof Schema) && !this.catalogOrSchemaFilter;
    }

    protected static class Filter {
        private Class<DatabaseObject> objectType;
        private Pattern nameMatcher;

        public Filter(Class<DatabaseObject> objectType, Pattern nameMatcher) {
            this.objectType = objectType;
            this.nameMatcher = nameMatcher;
        }

        protected boolean matches(DatabaseObject object) {
            if (object == null) {
                return false;
            }
            Boolean matches = null;
            if (this.objectType != null && !this.objectType.isAssignableFrom(object.getClass())) {
                matches = false;
            }
            if (matches == null) {
                matches = object.getName() != null && this.nameMatcher.matcher(object.getName()).matches();
            }
            if (!matches.booleanValue()) {
                if (object instanceof Column) {
                    return this.matches(((Column)object).getRelation());
                }
                if (object instanceof Index) {
                    return this.matches(((Index)object).getTable());
                }
                if (object instanceof ForeignKey) {
                    return this.matches(((ForeignKey)object).getForeignKeyTable());
                }
                if (object instanceof PrimaryKey) {
                    return this.matches(((PrimaryKey)object).getTable());
                }
                if (object instanceof UniqueConstraint) {
                    return this.matches(((UniqueConstraint)object).getTable());
                }
                if (object instanceof Data) {
                    return this.matches(((Data)object).getTable());
                }
            }
            return matches;
        }
    }

    public static enum FilterType {
        INCLUDE,
        EXCLUDE;

    }
}

