/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.spring;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.sql.DataSource;
import liquibase.exception.LiquibaseException;
import liquibase.integration.spring.SpringLiquibase;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.logging.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;

public class MultiTenantSpringLiquibase
implements InitializingBean,
ResourceLoaderAware {
    private final List<DataSource> dataSources = new ArrayList<DataSource>();
    private Logger log = LogService.getLog(MultiTenantSpringLiquibase.class);
    private String jndiBase;
    private DataSource dataSource;
    private List<String> schemas;
    private ResourceLoader resourceLoader;
    private String changeLog;
    private String contexts;
    private String labels;
    private Map<String, String> parameters;
    private String defaultSchema;
    private boolean dropFirst;
    private boolean shouldRun = true;
    private File rollbackFile;

    public void afterPropertiesSet() throws Exception {
        if (this.dataSource != null || this.schemas != null) {
            if (this.dataSource == null && this.schemas != null) {
                throw new LiquibaseException("When schemas are defined you should also define a base dataSource");
            }
            if (this.dataSource != null) {
                this.log.info(LogType.LOG, "Schema based multitenancy enabled");
                if (this.schemas == null || this.schemas.isEmpty()) {
                    this.log.warning(LogType.LOG, "Schemas not defined, using defaultSchema only");
                    this.schemas = new ArrayList<String>();
                    this.schemas.add(this.defaultSchema);
                }
                this.runOnAllSchemas();
            }
        } else {
            this.log.info(LogType.LOG, "DataSources based multitenancy enabled");
            this.resolveDataSources();
            this.runOnAllDataSources();
        }
    }

    private void resolveDataSources() throws NamingException {
        InitialContext context = new InitialContext();
        int lastIndexOf = this.jndiBase.lastIndexOf("/");
        String jndiRoot = this.jndiBase.substring(0, lastIndexOf);
        String jndiParent = this.jndiBase.substring(lastIndexOf + 1);
        Context base = (Context)context.lookup(jndiRoot);
        NamingEnumeration<NameClassPair> list = base.list(jndiParent);
        while (list.hasMoreElements()) {
            NameClassPair entry = (NameClassPair)list.nextElement();
            String name = entry.getName();
            String jndiUrl = entry.isRelative() ? this.jndiBase + "/" + name : name;
            Object lookup = context.lookup(jndiUrl);
            if (lookup instanceof DataSource) {
                this.dataSources.add((DataSource)lookup);
                this.log.debug(LogType.LOG, "Added a data source at " + jndiUrl);
                continue;
            }
            this.log.info(LogType.LOG, "Skipping a resource " + jndiUrl + " not compatible with DataSource.");
        }
    }

    private void runOnAllDataSources() throws LiquibaseException {
        for (DataSource aDataSource : this.dataSources) {
            this.log.info(LogType.LOG, "Initializing Liquibase for data source " + aDataSource);
            SpringLiquibase liquibase = this.getSpringLiquibase(aDataSource);
            liquibase.afterPropertiesSet();
            this.log.info(LogType.LOG, "Liquibase ran for data source " + aDataSource);
        }
    }

    private void runOnAllSchemas() throws LiquibaseException {
        for (String schema : this.schemas) {
            if ("default".equals(schema)) {
                schema = null;
            }
            this.log.info(LogType.LOG, "Initializing Liquibase for schema " + schema);
            SpringLiquibase liquibase = this.getSpringLiquibase(this.dataSource);
            liquibase.setDefaultSchema(schema);
            liquibase.afterPropertiesSet();
            this.log.info(LogType.LOG, "Liquibase ran for schema " + schema);
        }
    }

    private SpringLiquibase getSpringLiquibase(DataSource dataSource) {
        SpringLiquibase liquibase = new SpringLiquibase();
        liquibase.setChangeLog(this.changeLog);
        liquibase.setChangeLogParameters(this.parameters);
        liquibase.setContexts(this.contexts);
        liquibase.setLabels(this.labels);
        liquibase.setDropFirst(this.dropFirst);
        liquibase.setShouldRun(this.shouldRun);
        liquibase.setRollbackFile(this.rollbackFile);
        liquibase.setResourceLoader(this.resourceLoader);
        liquibase.setDataSource(dataSource);
        liquibase.setDefaultSchema(this.defaultSchema);
        return liquibase;
    }

    public String getJndiBase() {
        return this.jndiBase;
    }

    public void setJndiBase(String jndiBase) {
        this.jndiBase = jndiBase;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public void setChangeLog(String changeLog) {
        this.changeLog = changeLog;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String contexts) {
        this.contexts = contexts;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public boolean isDropFirst() {
        return this.dropFirst;
    }

    public void setDropFirst(boolean dropFirst) {
        this.dropFirst = dropFirst;
    }

    public boolean isShouldRun() {
        return this.shouldRun;
    }

    public void setShouldRun(boolean shouldRun) {
        this.shouldRun = shouldRun;
    }

    public File getRollbackFile() {
        return this.rollbackFile;
    }

    public void setRollbackFile(File rollbackFile) {
        this.rollbackFile = rollbackFile;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

