/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.resource.AbstractResourceAccessor;
import liquibase.util.SpringBootFatJar;
import liquibase.util.StringUtils;

public class ClassLoaderResourceAccessor
extends AbstractResourceAccessor {
    private ClassLoader classLoader;

    public ClassLoaderResourceAccessor() {
        this.classLoader = this.getClass().getClassLoader();
        this.init();
    }

    public ClassLoaderResourceAccessor(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.init();
    }

    @Override
    public Set<InputStream> getResourcesAsStream(String path) throws IOException {
        Enumeration<URL> resources = this.classLoader.getResources(path);
        if (resources == null || !resources.hasMoreElements()) {
            return null;
        }
        HashSet<String> seenUrls = new HashSet<String>();
        HashSet<InputStream> returnSet = new HashSet<InputStream>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (seenUrls.contains(url.toExternalForm())) continue;
            seenUrls.add(url.toExternalForm());
            LogService.getLog(this.getClass()).debug(LogType.LOG, "Opening " + url.toExternalForm() + " as " + path);
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            InputStream resourceAsStream = connection.getInputStream();
            if (resourceAsStream == null) continue;
            returnSet.add(resourceAsStream);
        }
        return returnSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> list(String relativeTo, String path, boolean includeFiles, boolean includeDirectories, boolean recursive) throws IOException {
        path = this.convertToPath(relativeTo, path);
        Enumeration<URL> fileUrls = this.classLoader.getResources(path);
        HashSet<String> returnSet = new HashSet<String>();
        if (!fileUrls.hasMoreElements() && (path.startsWith("jar:") || path.startsWith("file:") || path.startsWith("wsjar:file:") || path.startsWith("zip:"))) {
            fileUrls = new Vector<URL>(Arrays.asList(new URL(path))).elements();
        }
        while (fileUrls.hasMoreElements()) {
            URL fileUrl = fileUrls.nextElement();
            if (fileUrl.toExternalForm().startsWith("jar:file:") || fileUrl.toExternalForm().startsWith("wsjar:file:") || fileUrl.toExternalForm().startsWith("zip:")) {
                String[] zipAndFile = fileUrl.getFile().split("!");
                String zipFilePath = zipAndFile[0];
                zipFilePath = zipFilePath.matches("file:\\/[A-Za-z]:\\/.*") ? zipFilePath.replaceFirst("file:\\/", "") : zipFilePath.replaceFirst("file:", "");
                zipFilePath = URLDecoder.decode(zipFilePath, LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding());
                if ((path = SpringBootFatJar.getPathForResource(path)).startsWith("classpath:")) {
                    path = path.replaceFirst("classpath:", "");
                }
                if (path.startsWith("classpath*:")) {
                    path = path.replaceFirst("classpath\\*:", "");
                }
                try (JarFile zipfile = new JarFile(zipFilePath, false);){
                    Enumeration<JarEntry> entries = zipfile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().startsWith(path)) continue;
                        if (!recursive) {
                            String pathAsDir;
                            String string = pathAsDir = path.endsWith("/") ? path : path + "/";
                            if (!entry.getName().startsWith(pathAsDir) || entry.getName().substring(pathAsDir.length()).contains("/")) continue;
                        }
                        if (entry.isDirectory() && includeDirectories) {
                            returnSet.add(entry.getName());
                            continue;
                        }
                        if (!includeFiles) continue;
                        returnSet.add(entry.getName());
                    }
                }
            }
            try {
                File file = new File(fileUrl.toURI());
                if (file.exists()) {
                    this.getContents(file, recursive, includeFiles, includeDirectories, path, returnSet);
                }
            }
            catch (IllegalArgumentException | URISyntaxException file) {
                // empty catch block
            }
            Enumeration<URL> resources = this.classLoader.getResources(path);
            while (resources.hasMoreElements()) {
                String url = resources.nextElement().toExternalForm();
                url = url.replaceFirst("^\\Q" + path + "\\E", "");
                returnSet.add(url);
            }
        }
        if (returnSet.isEmpty()) {
            return null;
        }
        return returnSet;
    }

    @Override
    public ClassLoader toClassLoader() {
        return this.classLoader;
    }

    public String toString() {
        String description;
        if (this.classLoader instanceof URLClassLoader) {
            ArrayList<String> urls = new ArrayList<String>();
            for (URL url : ((URLClassLoader)this.classLoader).getURLs()) {
                urls.add(url.toExternalForm());
            }
            description = StringUtils.join(urls, ",");
        } else {
            description = this.classLoader.getClass().getName();
        }
        return this.getClass().getName() + "(" + description + ")";
    }
}

