/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.common.BuilderType;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.ParameterProvidedMethods;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.selector.MethodSelectors;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;

public class ObjectFactoryMethodResolver {
    private ObjectFactoryMethodResolver() {
    }

    public static MethodReference getFactoryMethod(Method method, Type targetType, SelectionParameters selectionParameters, MappingBuilderContext ctx) {
        MethodSelectors selectors = new MethodSelectors(ctx.getTypeUtils(), ctx.getElementUtils(), ctx.getTypeFactory());
        List<SelectedMethod<SourceMethod>> matchingFactoryMethods = selectors.getMatchingMethods(method, ObjectFactoryMethodResolver.getAllAvailableMethods(method, ctx.getSourceModel()), java.util.Collections.emptyList(), targetType.getEffectiveType(), SelectionCriteria.forFactoryMethods(selectionParameters));
        if (matchingFactoryMethods.isEmpty()) {
            return ObjectFactoryMethodResolver.findBuilderFactoryMethod(targetType);
        }
        if (matchingFactoryMethods.size() > 1) {
            ctx.getMessager().printMessage((Element)method.getExecutable(), Message.GENERAL_AMBIGIOUS_FACTORY_METHOD, targetType.getEffectiveType(), Strings.join(matchingFactoryMethods, ", "));
            return null;
        }
        SelectedMethod<SourceMethod> matchingFactoryMethod = Collections.first(matchingFactoryMethods);
        Parameter providingParameter = method.getContextProvidedMethods().getParameterForProvidedMethod(matchingFactoryMethod.getMethod());
        if (providingParameter != null) {
            return MethodReference.forParameterProvidedMethod(matchingFactoryMethod.getMethod(), providingParameter, matchingFactoryMethod.getParameterBindings());
        }
        MapperReference ref = MapperReference.findMapperReference(ctx.getMapperReferences(), matchingFactoryMethod.getMethod());
        return MethodReference.forMapperReference(matchingFactoryMethod.getMethod(), ref, matchingFactoryMethod.getParameterBindings());
    }

    private static MethodReference findBuilderFactoryMethod(Type targetType) {
        BuilderType builder = targetType.getBuilderType();
        if (builder == null) {
            return null;
        }
        ExecutableElement builderCreationMethod = builder.getBuilderCreationMethod();
        if (builderCreationMethod.getKind() == ElementKind.CONSTRUCTOR) {
            return null;
        }
        if (!builder.getBuildingType().isAssignableTo(targetType)) {
            return null;
        }
        return MethodReference.forStaticBuilder(builderCreationMethod.getSimpleName().toString(), builder.getOwningType());
    }

    private static List<SourceMethod> getAllAvailableMethods(Method method, List<SourceMethod> sourceModelMethods) {
        ParameterProvidedMethods contextProvidedMethods = method.getContextProvidedMethods();
        if (contextProvidedMethods.isEmpty()) {
            return sourceModelMethods;
        }
        List<SourceMethod> methodsProvidedByParams = contextProvidedMethods.getAllProvidedMethodsInParameterOrder(method.getContextParameters());
        ArrayList<SourceMethod> availableMethods = new ArrayList<SourceMethod>(methodsProvidedByParams.size() + sourceModelMethods.size());
        for (SourceMethod methodProvidedByParams : methodsProvidedByParams) {
            if (!methodProvidedByParams.hasObjectFactoryAnnotation()) continue;
            availableMethods.add(methodProvidedByParams);
        }
        availableMethods.addAll(sourceModelMethods);
        return availableMethods;
    }
}

