/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source.selector;

import java.util.ArrayList;
import java.util.List;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.selector.MethodSelector;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;
import org.mapstruct.ap.internal.util.Collections;

public class InheritanceSelector
implements MethodSelector {
    @Override
    public <T extends Method> List<SelectedMethod<T>> getMatchingMethods(Method mappingMethod, List<SelectedMethod<T>> methods, List<Type> sourceTypes, Type targetType, SelectionCriteria criteria) {
        if (sourceTypes.size() != 1) {
            return methods;
        }
        Type singleSourceType = Collections.first(sourceTypes);
        ArrayList<SelectedMethod<T>> candidatesWithBestMatchingSourceType = new ArrayList<SelectedMethod<T>>();
        int bestMatchingSourceTypeDistance = Integer.MAX_VALUE;
        for (SelectedMethod<T> method : methods) {
            Parameter singleSourceParam = Collections.first(method.getMethod().getSourceParameters());
            int sourceTypeDistance = singleSourceType.distanceTo(singleSourceParam.getType());
            bestMatchingSourceTypeDistance = this.addToCandidateListIfMinimal(candidatesWithBestMatchingSourceType, bestMatchingSourceTypeDistance, method, sourceTypeDistance);
        }
        return candidatesWithBestMatchingSourceType;
    }

    private <T extends Method> int addToCandidateListIfMinimal(List<SelectedMethod<T>> candidatesWithBestMathingType, int bestMatchingTypeDistance, SelectedMethod<T> method, int currentTypeDistance) {
        if (currentTypeDistance == bestMatchingTypeDistance) {
            candidatesWithBestMathingType.add(method);
        } else if (currentTypeDistance < bestMatchingTypeDistance) {
            bestMatchingTypeDistance = currentTypeDistance;
            candidatesWithBestMathingType.clear();
            candidatesWithBestMathingType.add(method);
        }
        return bestMatchingTypeDistance;
    }
}

