/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.BigDecimalParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.ByteArrayParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.ByteParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.DateParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.DoubleParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.FloatParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.IntParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.LongParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.NullParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ReaderParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.SerializableParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.ShortParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.StreamParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.StringParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.TimeParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.TimestampParameter;
import org.mariadb.jdbc.internal.util.ExceptionMapper;

public abstract class AbstractMariaDbPrepareStatement
extends MariaDbStatement
implements PreparedStatement {
    protected boolean useFractionalSeconds;

    public AbstractMariaDbPrepareStatement(MariaDbConnection connection, int autoGeneratedKeys) {
        super(connection, autoGeneratedKeys);
    }

    protected abstract boolean isNoBackslashEscapes();

    protected abstract boolean useFractionalSeconds();

    protected abstract Calendar cal();

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, MariaDbType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new ReaderParameter(reader, length, this.isNoBackslashEscapes()));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, MariaDbType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new ReaderParameter(reader, length, this.isNoBackslashEscapes()));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        if (reader == null) {
            this.setNull(parameterIndex, MariaDbType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new ReaderParameter(reader, this.isNoBackslashEscapes()));
    }

    @Override
    public void setRef(int parameterIndex, Ref ref) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("REF not supported");
    }

    @Override
    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        if (blob == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(blob.getBinaryStream(), this.isNoBackslashEscapes()));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (inputStream == null) {
            this.setNull(parameterIndex, MariaDbType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(inputStream, length, this.isNoBackslashEscapes()));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setNull(parameterIndex, MariaDbType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(inputStream, this.isNoBackslashEscapes()));
    }

    @Override
    public void setClob(int parameterIndex, Clob clob) throws SQLException {
        if (clob == null) {
            this.setNull(parameterIndex, MariaDbType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new ReaderParameter(clob.getCharacterStream(), clob.length(), this.isNoBackslashEscapes()));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setArray(int parameterIndex, Array array) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("Arrays not supported");
    }

    @Override
    public void setDate(int parameterIndex, Date date, Calendar cal) throws SQLException {
        if (date == null) {
            this.setNull(parameterIndex, 91);
            return;
        }
        this.setParameter(parameterIndex, new DateParameter(date, cal, this.protocol.getOptions()));
    }

    @Override
    public void setDate(int parameterIndex, Date date) throws SQLException {
        this.setDate(parameterIndex, date, this.cal());
    }

    @Override
    public void setTime(int parameterIndex, Time time, Calendar cal) throws SQLException {
        if (time == null) {
            this.setNull(parameterIndex, MariaDbType.TIME);
            return;
        }
        this.setParameter(parameterIndex, new TimeParameter(time, cal, this.useFractionalSeconds()));
    }

    @Override
    public void setTime(int parameterIndex, Time time) throws SQLException {
        this.setTime(parameterIndex, time, this.cal());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp, Calendar cal) throws SQLException {
        if (timestamp == null) {
            this.setNull(parameterIndex, MariaDbType.DATETIME);
            return;
        }
        this.setParameter(parameterIndex, new TimestampParameter(timestamp, cal, this.useFractionalSeconds(), this.protocol.getOptions()));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp) throws SQLException {
        this.setTimestamp(parameterIndex, timestamp, this.cal());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameter(parameterIndex, new NullParameter());
    }

    public void setNull(int parameterIndex, MariaDbType mysqlType) throws SQLException {
        this.setParameter(parameterIndex, new NullParameter(mysqlType));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParameter(parameterIndex, new NullParameter());
    }

    protected abstract void setParameter(int var1, ParameterHolder var2) throws SQLException;

    @Override
    public void setURL(int parameterIndex, URL url) throws SQLException {
        this.setParameter(parameterIndex, new StringParameter(url.toString(), this.isNoBackslashEscapes()));
    }

    @Override
    public abstract ParameterMetaData getParameterMetaData() throws SQLException;

    @Override
    public void setRowId(int parameterIndex, RowId rowid) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("RowIDs not supported");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("NStrings not supported");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("NCharstreams not supported");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("NClobs not supported");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("NClobs not supported");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw ExceptionMapper.getFeatureNotSupportedException("SQlXML not supported");
    }

    @Override
    public void setObject(int parameterIndex, Object obj, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObject(parameterIndex, obj, targetSqlType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setObject(int parameterIndex, Object obj, int targetSqlType) throws SQLException {
        switch (targetSqlType) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case 70: 
            case 2000: 
            case 2002: 
            case 2003: 
            case 2005: 
            case 2006: 
            case 2009: 
            case 2011: {
                throw ExceptionMapper.getFeatureNotSupportedException("Type not supported");
            }
        }
        if (obj == null) {
            this.setNull(parameterIndex, 4);
            return;
        } else if (obj instanceof String) {
            if (targetSqlType == 2004) {
                throw ExceptionMapper.getSqlException("Cannot convert a String to a Blob");
            }
            String str = (String)obj;
            try {
                switch (targetSqlType) {
                    case -7: {
                        this.setBoolean(parameterIndex, Boolean.valueOf(str));
                        return;
                    }
                    case -6: {
                        this.setByte(parameterIndex, Byte.parseByte(str));
                        return;
                    }
                    case 5: {
                        this.setShort(parameterIndex, Short.parseShort(str));
                        return;
                    }
                    case 4: {
                        this.setInt(parameterIndex, Integer.parseInt(str));
                        return;
                    }
                    case 6: 
                    case 8: {
                        this.setDouble(parameterIndex, Double.valueOf(str));
                        return;
                    }
                    case 7: {
                        this.setFloat(parameterIndex, Float.valueOf(str).floatValue());
                        return;
                    }
                    case -5: {
                        this.setLong(parameterIndex, Long.valueOf(str));
                        return;
                    }
                    case 2: 
                    case 3: {
                        this.setBigDecimal(parameterIndex, new BigDecimal(str));
                        return;
                    }
                    case -1: 
                    case 1: 
                    case 12: {
                        this.setString(parameterIndex, str);
                        return;
                    }
                    case 93: {
                        if (obj != null && ((String)obj).startsWith("0000-00-00")) {
                            this.setTimestamp(parameterIndex, null);
                            return;
                        }
                        this.setTimestamp(parameterIndex, Timestamp.valueOf((String)obj));
                        return;
                    }
                    case 92: {
                        this.setTime(parameterIndex, Time.valueOf((String)obj));
                        return;
                    }
                    default: {
                        throw ExceptionMapper.getSqlException("Could not convert [" + str + "] to " + targetSqlType);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw ExceptionMapper.getSqlException("Could not convert [" + str + "] to " + targetSqlType, e);
            }
        } else if (obj instanceof Number) {
            this.testNumbers(targetSqlType);
            Number bd = (Number)obj;
            switch (targetSqlType) {
                case -6: {
                    this.setByte(parameterIndex, bd.byteValue());
                    return;
                }
                case 5: {
                    this.setShort(parameterIndex, bd.shortValue());
                    return;
                }
                case 4: {
                    this.setInt(parameterIndex, bd.intValue());
                    return;
                }
                case -5: {
                    this.setLong(parameterIndex, bd.longValue());
                    return;
                }
                case 6: 
                case 8: {
                    this.setDouble(parameterIndex, bd.doubleValue());
                    return;
                }
                case 7: {
                    this.setFloat(parameterIndex, bd.floatValue());
                    return;
                }
                case 2: 
                case 3: {
                    if (obj instanceof BigDecimal) {
                        this.setBigDecimal(parameterIndex, (BigDecimal)obj);
                        return;
                    }
                    this.setLong(parameterIndex, bd.longValue());
                    return;
                }
                case -7: {
                    this.setBoolean(parameterIndex, bd.shortValue() != 0);
                    return;
                }
                case 1: 
                case 12: {
                    this.setString(parameterIndex, bd.toString());
                    return;
                }
                default: {
                    throw ExceptionMapper.getSqlException("Could not convert [" + bd + "] to " + targetSqlType);
                }
            }
        } else if (obj instanceof byte[]) {
            if (targetSqlType != -2 && targetSqlType != -3 && targetSqlType != -4) throw ExceptionMapper.getSqlException("Can only convert a byte[] to BINARY, VARBINARY or LONGVARBINARY");
            this.setBytes(parameterIndex, (byte[])obj);
            return;
        } else if (obj instanceof Time) {
            this.setTime(parameterIndex, (Time)obj);
            return;
        } else if (obj instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)obj);
            return;
        } else if (obj instanceof Date) {
            this.setDate(parameterIndex, (Date)obj);
            return;
        } else if (obj instanceof java.util.Date) {
            long timemillis = ((java.util.Date)obj).getTime();
            if (targetSqlType == 91) {
                this.setDate(parameterIndex, new Date(timemillis));
                return;
            } else if (targetSqlType == 92) {
                this.setTime(parameterIndex, new Time(timemillis));
                return;
            } else {
                if (targetSqlType != 93) return;
                this.setTimestamp(parameterIndex, new Timestamp(timemillis));
            }
            return;
        } else if (obj instanceof Boolean) {
            this.testNumbers(targetSqlType);
            this.setBoolean(parameterIndex, (Boolean)obj);
            return;
        } else if (obj instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)obj);
            return;
        } else {
            if (!(obj instanceof BigInteger)) throw ExceptionMapper.getSqlException("Could not set parameter in setObject, could not convert: " + obj.getClass() + " to " + targetSqlType);
            this.setString(parameterIndex, obj.toString());
        }
    }

    @Override
    public void setObject(int parameterIndex, Object obj) throws SQLException {
        if (obj == null) {
            this.setNull(parameterIndex, 4);
        } else if (obj instanceof String) {
            this.setString(parameterIndex, (String)obj);
        } else if (obj instanceof Integer) {
            this.setInt(parameterIndex, (Integer)obj);
        } else if (obj instanceof Long) {
            this.setLong(parameterIndex, (Long)obj);
        } else if (obj instanceof Short) {
            this.setShort(parameterIndex, (Short)obj);
        } else if (obj instanceof Double) {
            this.setDouble(parameterIndex, (Double)obj);
        } else if (obj instanceof Float) {
            this.setFloat(parameterIndex, ((Float)obj).floatValue());
        } else if (obj instanceof Byte) {
            this.setByte(parameterIndex, (Byte)obj);
        } else if (obj instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])obj);
        } else if (obj instanceof Date) {
            this.setDate(parameterIndex, (Date)obj);
        } else if (obj instanceof Time) {
            this.setTime(parameterIndex, (Time)obj);
        } else if (obj instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)obj);
        } else if (obj instanceof java.util.Date) {
            this.setTimestamp(parameterIndex, new Timestamp(((java.util.Date)obj).getTime()));
        } else if (obj instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)obj);
        } else if (obj instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)obj);
        } else if (obj instanceof InputStream) {
            this.setBinaryStream(parameterIndex, (InputStream)obj);
        } else if (obj instanceof Reader) {
            this.setCharacterStream(parameterIndex, (Reader)obj);
        } else if (obj instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)obj);
        } else if (obj instanceof BigInteger) {
            this.setString(parameterIndex, obj.toString());
        } else if (obj instanceof Clob) {
            this.setClob(parameterIndex, (Clob)obj);
        } else {
            try {
                this.setParameter(parameterIndex, new SerializableParameter(obj, this.isNoBackslashEscapes()));
            }
            catch (IOException e) {
                throw ExceptionMapper.getSqlException("Could not set serializable parameter in setObject: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream stream, long length) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, MariaDbType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(stream, length, this.isNoBackslashEscapes()));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream stream) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, MariaDbType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(stream, this.isNoBackslashEscapes()));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, MariaDbType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(stream, length, this.isNoBackslashEscapes()));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream stream, long length) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, MariaDbType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(stream, length, this.isNoBackslashEscapes()));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream stream) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, MariaDbType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(stream, this.isNoBackslashEscapes()));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream stream, int length) throws SQLException {
        if (stream == null) {
            this.setNull(parameterIndex, MariaDbType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(stream, length, this.isNoBackslashEscapes()));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.setParameter(parameterIndex, new ByteParameter(value ? (byte)1 : 0));
    }

    @Override
    public void setByte(int parameterIndex, byte bit) throws SQLException {
        this.setParameter(parameterIndex, new ByteParameter(bit));
    }

    @Override
    public void setShort(int parameterIndex, short value) throws SQLException {
        this.setParameter(parameterIndex, new ShortParameter(value));
    }

    @Override
    public void setString(int parameterIndex, String str) throws SQLException {
        if (str == null) {
            this.setNull(parameterIndex, MariaDbType.VARCHAR);
            return;
        }
        this.setParameter(parameterIndex, new StringParameter(str, this.isNoBackslashEscapes()));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] bytes) throws SQLException {
        if (bytes == null) {
            this.setNull(parameterIndex, MariaDbType.BLOB);
            return;
        }
        this.setParameter(parameterIndex, new ByteArrayParameter(bytes, this.isNoBackslashEscapes()));
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.setParameter(parameterIndex, new StreamParameter(x, length, this.isNoBackslashEscapes()));
    }

    private void testNumbers(int targetSqlType) throws SQLException {
        switch (targetSqlType) {
            case -4: 
            case -3: 
            case -2: 
            case 91: 
            case 92: 
            case 93: 
            case 2004: {
                throw ExceptionMapper.getSqlException("Cannot convert to " + targetSqlType);
            }
        }
    }

    @Override
    public void setInt(int column, int value) throws SQLException {
        this.setParameter(column, new IntParameter(value));
    }

    @Override
    public void setLong(int parameterIndex, long value) throws SQLException {
        this.setParameter(parameterIndex, new LongParameter(value));
    }

    @Override
    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.setParameter(parameterIndex, new FloatParameter(value));
    }

    @Override
    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.setParameter(parameterIndex, new DoubleParameter(value));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull(parameterIndex, MariaDbType.DECIMAL);
            return;
        }
        this.setParameter(parameterIndex, new BigDecimalParameter(bigDecimal));
    }
}

