/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.query;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.List;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.query.ParameterizeQuery;
import org.mariadb.jdbc.internal.util.ExceptionMapper;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class MariaDbClientParameterizeQuery
implements ParameterizeQuery {
    private ParameterHolder[] parameters;
    private int paramCount;
    private byte[][] queryPartsArray;
    private byte[] rewriteFirstPart = null;
    private byte[] rewriteRepeatLastPart = null;
    private byte[] rewriteNotRepeatLastPart = null;

    @Override
    public int getQuerySize() throws IOException {
        long size = this.queryPartsArray[0].length;
        for (int i = 1; i < this.queryPartsArray.length; ++i) {
            size += this.parameters[i - 1].getApproximateTextProtocolLength();
            if (this.queryPartsArray[i].length == 0) continue;
            size += (long)this.queryPartsArray[i].length;
        }
        return (int)size;
    }

    @Override
    public byte[] getRewriteFirstPart() {
        return this.rewriteFirstPart;
    }

    public MariaDbClientParameterizeQuery(String query, boolean noBackslashEscapes, int rewriteOffset) {
        try {
            List<String> queryParts = Utils.createQueryParts(query, noBackslashEscapes);
            if (rewriteOffset != -1) {
                this.rewriteFirstPart = queryParts.get(0).substring(rewriteOffset + 1).getBytes("UTF-8");
                String lastPart = queryParts.get(queryParts.size() - 1);
                if (lastPart.indexOf(")") != -1) {
                    this.rewriteRepeatLastPart = lastPart.substring(0, lastPart.indexOf(")")).getBytes("UTF-8");
                    this.rewriteNotRepeatLastPart = lastPart.substring(lastPart.indexOf(")") + 1).getBytes("UTF-8");
                } else {
                    this.rewriteRepeatLastPart = lastPart.getBytes("UTF-8");
                    this.rewriteNotRepeatLastPart = new byte[0];
                }
            }
            this.queryPartsArray = new byte[queryParts.size()][];
            for (int i = 0; i < queryParts.size(); ++i) {
                this.queryPartsArray[i] = queryParts.get(i).getBytes("UTF-8");
            }
            this.paramCount = queryParts.size() - 1;
            this.parameters = new ParameterHolder[this.paramCount];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private MariaDbClientParameterizeQuery() {
    }

    public MariaDbClientParameterizeQuery cloneQuery() {
        MariaDbClientParameterizeQuery clientQuery = new MariaDbClientParameterizeQuery();
        clientQuery.parameters = new ParameterHolder[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            clientQuery.parameters[i] = this.parameters[i];
        }
        clientQuery.paramCount = this.paramCount;
        clientQuery.queryPartsArray = this.queryPartsArray;
        clientQuery.rewriteFirstPart = this.rewriteFirstPart;
        clientQuery.rewriteRepeatLastPart = this.rewriteRepeatLastPart;
        clientQuery.rewriteNotRepeatLastPart = this.rewriteNotRepeatLastPart;
        return clientQuery;
    }

    @Override
    public void setParameter(int position, ParameterHolder parameter) throws SQLException {
        if (position < 0 || position >= this.paramCount) {
            throw ExceptionMapper.getSqlException("Could not set parameter");
        }
        this.parameters[position] = parameter;
    }

    @Override
    public ParameterHolder[] getParameters() {
        return this.parameters;
    }

    @Override
    public void clearParameters() {
        this.parameters = new ParameterHolder[this.paramCount];
    }

    @Override
    public void validate() throws QueryException {
        if (this.containsNull(this.parameters)) {
            throw new QueryException("You need to set exactly " + this.paramCount + " parameters on the prepared statement");
        }
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        if (this.queryPartsArray.length == 0) {
            throw new AssertionError((Object)"Invalid query, queryParts was empty");
        }
        os.write(this.queryPartsArray[0]);
        for (int i = 1; i < this.queryPartsArray.length; ++i) {
            this.parameters[i - 1].writeTo(os);
            if (this.queryPartsArray[i].length == 0) continue;
            os.write(this.queryPartsArray[i]);
        }
    }

    @Override
    public void writeFirstRewritePart(OutputStream os) throws IOException {
        if (this.queryPartsArray.length == 0) {
            throw new AssertionError((Object)"Invalid query, queryParts was empty");
        }
        for (int i = 0; i < this.queryPartsArray.length - 1; ++i) {
            os.write(this.queryPartsArray[i]);
            this.parameters[i].writeTo(os);
        }
        if (this.rewriteRepeatLastPart != null) {
            os.write(this.rewriteRepeatLastPart);
        }
        os.write(41);
    }

    @Override
    public void writeLastRewritePart(OutputStream os) throws IOException {
        if (this.rewriteNotRepeatLastPart != null) {
            os.write(this.rewriteNotRepeatLastPart);
        }
    }

    @Override
    public int writeLastRewritePartLength() {
        if (this.rewriteNotRepeatLastPart != null) {
            return this.rewriteNotRepeatLastPart.length;
        }
        return 0;
    }

    @Override
    public void writeToRewritablePart(OutputStream os, int rewriteOffset) throws IOException {
        if (this.queryPartsArray.length == 0) {
            throw new AssertionError((Object)"Invalid query, queryParts was empty");
        }
        os.write(new byte[]{44, 40});
        os.write(this.rewriteFirstPart);
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i].writeTo(os);
            if (i < this.parameters.length - 1) {
                os.write(this.queryPartsArray[i + 1]);
                continue;
            }
            os.write(this.rewriteRepeatLastPart);
        }
        os.write(41);
    }

    @Override
    public int writeToRewritablePartLength(int rewriteOffset) throws IOException {
        long length = 3 + this.rewriteFirstPart.length;
        for (int i = 0; i < this.parameters.length; ++i) {
            length += this.parameters[i].getApproximateTextProtocolLength();
            if (i < this.parameters.length - 1) {
                length += (long)this.queryPartsArray[i + 1].length;
                continue;
            }
            length += (long)this.rewriteRepeatLastPart.length;
        }
        return (int)length;
    }

    private boolean containsNull(ParameterHolder[] parameters) {
        for (ParameterHolder ph : parameters) {
            if (ph != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public byte[][] getQueryPartsArray() {
        return this.queryPartsArray;
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(new String(this.queryPartsArray[0]));
        for (i = 1; i < this.queryPartsArray.length; ++i) {
            sb.append("?");
            if (this.queryPartsArray[i].length == 0) continue;
            sb.append(new String(this.queryPartsArray[i]));
        }
        if (this.parameters.length > 0) {
            sb.append(", parameters : [");
            for (i = 0; i < this.parameters.length; ++i) {
                if (this.parameters[i] == null) {
                    sb.append("null");
                } else {
                    sb.append(this.parameters[i].toString());
                }
                if (i == this.parameters.length - 1) continue;
                sb.append(",");
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

