/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.dao;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.mariadb.jdbc.internal.util.ExceptionCode;
import org.mariadb.jdbc.internal.util.SqlStates;

public class QueryException
extends Exception {
    private static final long serialVersionUID = 974263994278018455L;
    private int errorCode;
    private String sqlState;
    private String message;
    private volatile QueryException next;
    private static final AtomicReferenceFieldUpdater<QueryException, QueryException> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(QueryException.class, QueryException.class, "next");

    public QueryException(String message) {
        super(message);
        this.message = message;
        this.errorCode = -1;
        this.sqlState = "HY0000";
    }

    public QueryException(String message, int errorCode, String sqlState) {
        super(message);
        this.message = message;
        this.errorCode = errorCode;
        this.sqlState = sqlState;
    }

    public QueryException(String message, int errorCode, SqlStates sqlState) {
        super(message);
        this.message = message;
        this.errorCode = errorCode;
        this.sqlState = sqlState.getSqlState();
    }

    public QueryException(String message, ExceptionCode exceptionCode) {
        super(message);
        this.message = message;
        this.errorCode = -1;
        this.sqlState = exceptionCode.sqlState;
    }

    public QueryException(String message, int errorCode, String sqlState, Throwable cause) {
        super(message, cause);
        this.message = message;
        this.errorCode = errorCode;
        this.sqlState = sqlState;
    }

    public QueryException(String message, int errorCode, SqlStates sqlState, Throwable cause) {
        super(message, cause);
        this.message = message;
        this.errorCode = errorCode;
        this.sqlState = sqlState.getSqlState();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isPrepareError() {
        return false;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final String getSqlState() {
        return this.sqlState;
    }

    public void setSqlState(String sqlState) {
        this.sqlState = sqlState;
    }

    public void setNextException(QueryException ex) {
        QueryException current = this;
        while (true) {
            QueryException next;
            if ((next = current.next) != null) {
                current = next;
                continue;
            }
            if (nextUpdater.compareAndSet(current, null, ex)) {
                return;
            }
            current = current.next;
        }
    }

    public QueryException getNextException() {
        return this.next;
    }
}

