/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send.authentication;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.com.send.authentication.AuthenticationPlugin;
import org.mariadb.jdbc.internal.com.send.authentication.gssapi.GssUtility;
import org.mariadb.jdbc.internal.com.send.authentication.gssapi.GssapiAuth;
import org.mariadb.jdbc.internal.com.send.authentication.gssapi.StandardGssapiAuthentication;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class SendGssApiAuthPacket
implements AuthenticationPlugin {
    private static final GssapiAuth gssapiAuth;
    private byte[] authData;
    private String optionServicePrincipalName;

    public SendGssApiAuthPacket(byte[] authData, String servicePrincipalName) {
        this.authData = authData;
        this.optionServicePrincipalName = servicePrincipalName;
    }

    @Override
    public Buffer process(PacketOutputStream out, PacketInputStream in, AtomicInteger sequence) throws IOException, SQLException {
        Buffer buffer = new Buffer(this.authData);
        String serverSpn = buffer.readStringNullEnd(StandardCharsets.UTF_8);
        String servicePrincipalName = this.optionServicePrincipalName != null && !this.optionServicePrincipalName.isEmpty() ? this.optionServicePrincipalName : serverSpn;
        String mechanisms = buffer.readStringNullEnd(StandardCharsets.UTF_8);
        if (mechanisms.isEmpty()) {
            mechanisms = "Kerberos";
        }
        gssapiAuth.authenticate(out, in, sequence, servicePrincipalName, mechanisms);
        buffer = in.getPacket(true);
        sequence.set(in.getLastPacketSeq());
        return buffer;
    }

    static {
        GssapiAuth init;
        try {
            init = GssUtility.getAuthenticationMethod();
        }
        catch (Throwable t) {
            init = new StandardGssapiAuthentication();
        }
        gssapiAuth = init;
    }
}

