/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.security;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.Fetch;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.aggregation.AggregateQuery;
import org.molgenis.data.aggregation.AggregateResult;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.security.util.SecurityDecoratorUtils;
import org.molgenis.security.core.Permission;

public class RepositorySecurityDecorator
extends AbstractRepositoryDecorator<Entity> {
    public RepositorySecurityDecorator(Repository<Entity> delegateRepository) {
        super(delegateRepository);
    }

    public Iterator<Entity> iterator() {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.READ);
        return this.delegate().iterator();
    }

    public void forEachBatched(Fetch fetch, Consumer<List<Entity>> consumer, int batchSize) {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.READ);
        this.delegate().forEachBatched(fetch, consumer, batchSize);
    }

    public void close() throws IOException {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.WRITE);
        this.delegate().close();
    }

    public long count(Query<Entity> q) {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.COUNT);
        return this.delegate().count(q);
    }

    public Stream<Entity> findAll(Query<Entity> q) {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.READ);
        return this.delegate().findAll(q);
    }

    public Entity findOne(Query<Entity> q) {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.READ);
        return this.delegate().findOne(q);
    }

    public Entity findOneById(Object id) {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.READ);
        return this.delegate().findOneById(id);
    }

    public Entity findOneById(Object id, Fetch fetch) {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.READ);
        return this.delegate().findOneById(id, fetch);
    }

    public Stream<Entity> findAll(Stream<Object> ids) {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.READ);
        return this.delegate().findAll(ids);
    }

    public Stream<Entity> findAll(Stream<Object> ids, Fetch fetch) {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.READ);
        return this.delegate().findAll(ids, fetch);
    }

    public long count() {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.COUNT);
        return this.delegate().count();
    }

    public void update(Entity entity) {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.WRITE);
        this.delegate().update(entity);
    }

    public void update(Stream<Entity> entities) {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.WRITE);
        this.delegate().update(entities);
    }

    public void delete(Entity entity) {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.WRITE);
        this.delegate().delete(entity);
    }

    public void delete(Stream<Entity> entities) {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.WRITE);
        this.delegate().delete(entities);
    }

    public void deleteById(Object id) {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.WRITE);
        this.delegate().deleteById(id);
    }

    public void deleteAll(Stream<Object> ids) {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.WRITE);
        this.delegate().deleteAll(ids);
    }

    public void deleteAll() {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.WRITE);
        this.delegate().deleteAll();
    }

    public void add(Entity entity) {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.WRITE);
        this.delegate().add(entity);
    }

    public Integer add(Stream<Entity> entities) {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.WRITE);
        return this.delegate().add(entities);
    }

    public AggregateResult aggregate(AggregateQuery aggregateQuery) {
        EntityType entityType = this.delegate().getEntityType();
        SecurityDecoratorUtils.validatePermission(entityType, Permission.COUNT);
        return this.delegate().aggregate(aggregateQuery);
    }
}

