/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.security;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.molgenis.data.MolgenisDataAccessException;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.system.SystemEntityTypeRegistry;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.PermissionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SystemEntityTypeRegistryImpl
implements SystemEntityTypeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(SystemEntityTypeRegistryImpl.class);
    private final Map<String, SystemEntityType> systemEntityTypeMap;
    private final PermissionService permissionService;

    SystemEntityTypeRegistryImpl(PermissionService permissionService) {
        this.permissionService = Objects.requireNonNull(permissionService);
        this.systemEntityTypeMap = Maps.newHashMap();
    }

    public SystemEntityType getSystemEntityType(String entityTypeId) {
        SystemEntityType systemEntityType = this.systemEntityTypeMap.get(entityTypeId);
        if (systemEntityType != null) {
            this.validateReadPermission(systemEntityType);
        }
        return systemEntityType;
    }

    public Stream<SystemEntityType> getSystemEntityTypes() {
        return this.systemEntityTypeMap.values().stream().filter(this::isReadAllowed);
    }

    public boolean hasSystemEntityType(String entityTypeId) {
        return this.systemEntityTypeMap.containsKey(entityTypeId);
    }

    public void addSystemEntityType(SystemEntityType systemEntityType) {
        String systemEntityTypeName = systemEntityType.getId();
        LOG.trace("Registering system entity [{}] ...", (Object)systemEntityTypeName);
        this.systemEntityTypeMap.put(systemEntityTypeName, systemEntityType);
    }

    public boolean hasSystemAttribute(String attrIdentifier) {
        return this.systemEntityTypeMap.values().stream().map(systemEntityType -> SystemEntityTypeRegistryImpl.getSystemAttribute(systemEntityType, attrIdentifier)).anyMatch(Objects::nonNull);
    }

    public Attribute getSystemAttribute(String attrIdentifier) {
        return this.systemEntityTypeMap.values().stream().map(systemEntityType -> {
            Attribute attribute = SystemEntityTypeRegistryImpl.getSystemAttribute(systemEntityType, attrIdentifier);
            if (attribute != null) {
                this.validateReadPermission((SystemEntityType)systemEntityType);
            }
            return attribute;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private boolean isReadAllowed(SystemEntityType systemEntityType) {
        return this.permissionService.hasPermissionOnEntityType(systemEntityType.getId(), Permission.COUNT);
    }

    private void validateReadPermission(SystemEntityType systemEntityType) {
        if (!this.isReadAllowed(systemEntityType)) {
            throw new MolgenisDataAccessException(String.format("No read permission on entity type '%s' with id '%s'", systemEntityType.getLabel(), systemEntityType.getId()));
        }
    }

    private static Attribute getSystemAttribute(SystemEntityType systemEntityType, String attrIdentifier) {
        return SystemEntityTypeRegistryImpl.getSystemAttributeRec(systemEntityType.getAllAttributes(), attrIdentifier);
    }

    private static Attribute getSystemAttributeRec(Iterable<Attribute> attrs, String attrIdentifier) {
        for (Attribute attr : attrs) {
            if (attr.getIdentifier() != null && attr.getIdentifier().equals(attrIdentifier)) {
                return attr;
            }
            if (attr.getDataType() != AttributeType.COMPOUND) continue;
            return SystemEntityTypeRegistryImpl.getSystemAttributeRec(attr.getChildren(), attrIdentifier);
        }
        return null;
    }
}

