/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.security.aggregation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.molgenis.data.aggregation.AggregateResult;
import org.molgenis.data.security.aggregation.AggregateAnonymizer;
import org.molgenis.data.security.aggregation.AnonymizedAggregateResult;
import org.springframework.stereotype.Component;

@Component
public class AggregateAnonymizerImpl
implements AggregateAnonymizer {
    @Override
    public AnonymizedAggregateResult anonymize(AggregateResult result, int threshold) {
        ArrayList anonymizedmatrix = Lists.newArrayList();
        for (List row : result.getMatrix()) {
            List anonymizedRow = Lists.transform((List)row, input -> {
                if (input == null) {
                    return null;
                }
                return input <= (long)threshold ? -1L : input;
            });
            anonymizedmatrix.add(anonymizedRow);
        }
        return new AnonymizedAggregateResult(anonymizedmatrix, result.getxLabels(), result.getyLabels(), threshold);
    }
}

