/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.security.aggregation;

import java.util.Objects;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.aggregation.AggregateQuery;
import org.molgenis.data.aggregation.AggregateResult;
import org.molgenis.data.security.aggregation.AggregateAnonymizer;
import org.molgenis.settings.AppSettings;

public class AggregateAnonymizerRepositoryDecorator<E extends Entity>
extends AbstractRepositoryDecorator<E> {
    private final AggregateAnonymizer aggregateAnonymizer;
    private final AppSettings appSettings;

    public AggregateAnonymizerRepositoryDecorator(Repository<E> delegateRepository, AggregateAnonymizer aggregateAnonymizer, AppSettings appSettings) {
        super(delegateRepository);
        this.appSettings = Objects.requireNonNull(appSettings);
        this.aggregateAnonymizer = Objects.requireNonNull(aggregateAnonymizer);
    }

    public AggregateResult aggregate(AggregateQuery aggregateQuery) {
        AggregateResult result = this.delegate().aggregate(aggregateQuery);
        Integer threshold = this.appSettings.getAggregateThreshold();
        if (threshold != null && threshold > 0) {
            result = this.aggregateAnonymizer.anonymize(result, threshold);
        }
        return result;
    }
}

