/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.security.auth;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.security.auth.AuthorityMetaData;
import org.molgenis.data.security.auth.GroupMetaData;
import org.molgenis.data.security.auth.SecurityPackage;
import org.springframework.stereotype.Component;

@Component
public class GroupAuthorityMetaData
extends SystemEntityType {
    private static final String SIMPLE_NAME = "GroupAuthority";
    public static final String GROUP_AUTHORITY = "sys_sec_GroupAuthority";
    public static final String GROUP = "Group";
    public static final String ID = "id";
    private final SecurityPackage securityPackage;
    private final GroupMetaData groupMetaData;
    private final AuthorityMetaData authorityMetaData;

    GroupAuthorityMetaData(SecurityPackage securityPackage, GroupMetaData groupMetaData, AuthorityMetaData authorityMetaData) {
        super(SIMPLE_NAME, "sys_sec");
        this.securityPackage = Objects.requireNonNull(securityPackage);
        this.groupMetaData = Objects.requireNonNull(groupMetaData);
        this.authorityMetaData = Objects.requireNonNull(authorityMetaData);
    }

    public void init() {
        this.setLabel("Group authority");
        this.setPackage((Package)this.securityPackage);
        this.setExtends((EntityType)this.authorityMetaData);
        this.addAttribute(ID, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID}).setAuto(true).setVisible(false);
        this.addAttribute(GROUP, new EntityType.AttributeRole[0]).setDataType(AttributeType.XREF).setRefEntity((EntityType)this.groupMetaData).setAggregatable(true).setNillable(false);
    }

    public Set<SystemEntityType> getDependencies() {
        return Collections.singleton(this.authorityMetaData);
    }
}

