/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.security.auth;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.security.auth.AuthorityMetaData;
import org.molgenis.data.security.auth.SecurityPackage;
import org.springframework.stereotype.Component;

@Component
public class GroupMetaData
extends SystemEntityType {
    private static final String SIMPLE_NAME = "Group";
    public static final String GROUP = "sys_sec_Group";
    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String ACTIVE = "active";
    private final SecurityPackage securityPackage;
    private final AuthorityMetaData authorityMetaData;

    GroupMetaData(SecurityPackage securityPackage, AuthorityMetaData authorityMetaData) {
        super(SIMPLE_NAME, "sys_sec");
        this.securityPackage = Objects.requireNonNull(securityPackage);
        this.authorityMetaData = Objects.requireNonNull(authorityMetaData);
    }

    public void init() {
        this.setLabel(SIMPLE_NAME);
        this.setPackage((Package)this.securityPackage);
        this.setExtends((EntityType)this.authorityMetaData);
        this.addAttribute(ID, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID}).setAuto(true).setVisible(false);
        this.addAttribute(NAME, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_LABEL, EntityType.AttributeRole.ROLE_LOOKUP}).setLabel("Name").setNillable(false).setUnique(true);
        this.addAttribute(ACTIVE, new EntityType.AttributeRole[0]).setLabel("Active").setDataType(AttributeType.BOOL).setDefaultValue("true").setDescription("Boolean to indicate whether this group is in use.").setAggregatable(true).setNillable(false);
    }

    public Set<SystemEntityType> getDependencies() {
        return Collections.singleton(this.authorityMetaData);
    }
}

