/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.security.auth;

import java.util.Objects;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.security.auth.SecurityPackage;
import org.molgenis.data.security.auth.UserMetaData;
import org.springframework.stereotype.Component;

@Component
public class TokenMetaData
extends SystemEntityType {
    private static final String SIMPLE_NAME = "Token";
    public static final String TOKEN = "sys_sec_Token";
    public static final String TOKEN_ATTR = "token";
    public static final String ID = "id";
    public static final String USER = "User";
    public static final String EXPIRATIONDATE = "expirationDate";
    public static final String CREATIONDATE = "creationDate";
    public static final String DESCRIPTION = "description";
    private final SecurityPackage securityPackage;
    private final UserMetaData userMetaData;

    TokenMetaData(SecurityPackage securityPackage, UserMetaData userMetaData) {
        super(SIMPLE_NAME, "sys_sec");
        this.securityPackage = Objects.requireNonNull(securityPackage);
        this.userMetaData = Objects.requireNonNull(userMetaData);
    }

    public void init() {
        this.setLabel(SIMPLE_NAME);
        this.setPackage((Package)this.securityPackage);
        this.addAttribute(ID, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID}).setAuto(true).setVisible(false);
        this.addAttribute(USER, new EntityType.AttributeRole[0]).setDataType(AttributeType.XREF).setRefEntity((EntityType)this.userMetaData).setAggregatable(true).setNillable(false);
        this.addAttribute(TOKEN_ATTR, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_LABEL}).setLabel(SIMPLE_NAME).setUnique(true).setNillable(false);
        this.addAttribute(EXPIRATIONDATE, new EntityType.AttributeRole[0]).setDataType(AttributeType.DATE_TIME).setLabel("Expiration date").setNillable(true).setDescription("When expiration date is null it will never expire");
        this.addAttribute(CREATIONDATE, new EntityType.AttributeRole[0]).setDataType(AttributeType.DATE_TIME).setLabel("Creation date").setAuto(true).setReadOnly(true).setNillable(false);
        this.addAttribute(DESCRIPTION, new EntityType.AttributeRole[0]).setDataType(AttributeType.TEXT).setLabel("Description").setNillable(true);
    }
}

