/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.security.auth;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.security.auth.AuthorityMetaData;
import org.molgenis.data.security.auth.SecurityPackage;
import org.molgenis.data.security.auth.UserMetaData;
import org.springframework.stereotype.Component;

@Component
public class UserAuthorityMetaData
extends SystemEntityType {
    private static final String SIMPLE_NAME = "UserAuthority";
    public static final String USER_AUTHORITY = "sys_sec_UserAuthority";
    public static final String USER = "User";
    public static final String ID = "id";
    private final SecurityPackage securityPackage;
    private final UserMetaData userMetaData;
    private final AuthorityMetaData authorityMetaData;

    UserAuthorityMetaData(SecurityPackage securityPackage, UserMetaData userMetaData, AuthorityMetaData authorityMetaData) {
        super(SIMPLE_NAME, "sys_sec");
        this.securityPackage = Objects.requireNonNull(securityPackage);
        this.userMetaData = Objects.requireNonNull(userMetaData);
        this.authorityMetaData = Objects.requireNonNull(authorityMetaData);
    }

    public void init() {
        this.setLabel("User authority");
        this.setPackage((Package)this.securityPackage);
        this.setExtends((EntityType)this.authorityMetaData);
        this.addAttribute(ID, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID}).setAuto(true).setVisible(false);
        this.addAttribute(USER, new EntityType.AttributeRole[0]).setDataType(AttributeType.XREF).setRefEntity((EntityType)this.userMetaData).setAggregatable(true).setNillable(false);
    }

    public Set<SystemEntityType> getDependencies() {
        return Collections.singleton(this.authorityMetaData);
    }
}

