/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.security.auth;

import java.util.Arrays;
import java.util.Objects;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.security.auth.SecurityPackage;
import org.springframework.stereotype.Component;

@Component
public class UserMetaData
extends SystemEntityType {
    private static final String SIMPLE_NAME = "User";
    public static final String USER = "sys_sec_User";
    public static final String USERNAME = "username";
    public static final String SUPERUSER = "superuser";
    public static final String PASSWORD_ = "password_";
    public static final String TWO_FACTOR_AUTHENTICATION = "use2fa";
    public static final String EMAIL = "Email";
    public static final String GOOGLEACCOUNTID = "googleAccountId";
    public static final String ACTIVATIONCODE = "activationCode";
    public static final String ACTIVE = "active";
    public static final String CHANGE_PASSWORD = "changePassword";
    public static final String FIRSTNAME = "FirstName";
    public static final String MIDDLENAMES = "MiddleNames";
    public static final String LASTNAME = "LastName";
    public static final String TITLE = "Title";
    public static final String AFFILIATION = "Affiliation";
    public static final String DEPARTMENT = "Department";
    public static final String ROLE = "Role";
    public static final String ADDRESS = "Address";
    public static final String PHONE = "Phone";
    public static final String TOLLFREEPHONE = "tollFreePhone";
    public static final String FAX = "Fax";
    public static final String CITY = "City";
    public static final String COUNTRY = "Country";
    public static final String LANGUAGECODE = "languageCode";
    public static final String ID = "id";
    private final SecurityPackage securityPackage;

    public UserMetaData(SecurityPackage securityPackage) {
        super(SIMPLE_NAME, "sys_sec");
        this.securityPackage = Objects.requireNonNull(securityPackage);
    }

    public void init() {
        this.setLabel(SIMPLE_NAME);
        this.setPackage((Package)this.securityPackage);
        this.setDescription("Anyone who can login");
        this.addAttribute(ID, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID}).setAuto(true).setVisible(false).setDescription("automatically generated internal id, only for internal use.");
        this.addAttribute(USERNAME, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_LABEL, EntityType.AttributeRole.ROLE_LOOKUP}).setLabel("Username").setUnique(true).setNillable(false);
        this.addAttribute(PASSWORD_, new EntityType.AttributeRole[0]).setLabel("Password").setDescription("This is the hashed password, enter a new plaintext password to update.").setNillable(false);
        this.addAttribute(ACTIVATIONCODE, new EntityType.AttributeRole[0]).setLabel("Activation code").setNillable(true).setDescription("Used as alternative authentication mechanism to verify user email and/or if user has lost password.");
        this.addAttribute(ACTIVE, new EntityType.AttributeRole[0]).setLabel("Active").setDataType(AttributeType.BOOL).setDefaultValue("false").setDescription("Boolean to indicate if this account can be used to login").setAggregatable(true).setNillable(false);
        this.addAttribute(SUPERUSER, new EntityType.AttributeRole[0]).setLabel("Superuser").setDataType(AttributeType.BOOL).setDefaultValue("false").setAggregatable(true).setNillable(false);
        this.addAttribute(FIRSTNAME, new EntityType.AttributeRole[0]).setLabel("First name").setNillable(true);
        this.addAttribute(MIDDLENAMES, new EntityType.AttributeRole[0]).setLabel("Middle names").setNillable(true);
        this.addAttribute(LASTNAME, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_LOOKUP}).setLabel("Last name").setNillable(true);
        this.addAttribute(TITLE, new EntityType.AttributeRole[0]).setLabel(TITLE).setNillable(true).setDescription("An academic title, e.g. Prof.dr, PhD");
        this.addAttribute(AFFILIATION, new EntityType.AttributeRole[0]).setLabel(AFFILIATION).setNillable(true);
        this.addAttribute(DEPARTMENT, new EntityType.AttributeRole[0]).setDescription("Added from the old definition of MolgenisUser. Department of this contact.").setNillable(true);
        this.addAttribute(ROLE, new EntityType.AttributeRole[0]).setDescription("Indicate role of the contact, e.g. lab worker or PI.").setNillable(true);
        this.addAttribute(ADDRESS, new EntityType.AttributeRole[0]).setDescription("The address of the Contact.").setNillable(true).setDataType(AttributeType.TEXT);
        this.addAttribute(PHONE, new EntityType.AttributeRole[0]).setDescription("The telephone number of the Contact including the suitable area codes.").setNillable(true);
        this.addAttribute(EMAIL, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_LOOKUP}).setDescription("The email address of the Contact.").setUnique(true).setDataType(AttributeType.EMAIL).setNillable(false);
        this.addAttribute(FAX, new EntityType.AttributeRole[0]).setDescription("The fax number of the Contact.").setNillable(true);
        this.addAttribute(TOLLFREEPHONE, new EntityType.AttributeRole[0]).setLabel("Toll-free phone").setNillable(true).setDescription("A toll free phone number for the Contact, including suitable area codes.");
        this.addAttribute(CITY, new EntityType.AttributeRole[0]).setDescription("Added from the old definition of MolgenisUser. City of this contact.").setNillable(true);
        this.addAttribute(COUNTRY, new EntityType.AttributeRole[0]).setDescription("Added from the old definition of MolgenisUser. Country of this contact.").setNillable(true);
        this.addAttribute(CHANGE_PASSWORD, new EntityType.AttributeRole[0]).setLabel("Change password").setDataType(AttributeType.BOOL).setDefaultValue("false").setDescription("If true the user must first change his password before he can proceed").setAggregatable(true).setNillable(false);
        this.addAttribute(TWO_FACTOR_AUTHENTICATION, new EntityType.AttributeRole[0]).setLabel("Use two factor authentication").setDataType(AttributeType.BOOL).setDefaultValue("false").setDescription("Enables two factor authentication for this user if the application supports it");
        this.addAttribute(LANGUAGECODE, new EntityType.AttributeRole[0]).setLabel("Language code").setDescription("Selected language for this site.").setDataType(AttributeType.ENUM).setEnumOptions(Arrays.asList("en", "nl", "de", "es", "it", "pt", "fr", "xx")).setNillable(true);
        this.addAttribute(GOOGLEACCOUNTID, new EntityType.AttributeRole[0]).setLabel("Google account ID").setDescription("An identifier for the user, unique among all Google accounts and never reused.").setNillable(true);
    }
}

