/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.security.auth;

import com.google.common.collect.Iterators;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.security.auth.GroupMember;
import org.molgenis.data.security.auth.User;
import org.molgenis.data.security.auth.UserAuthority;
import org.molgenis.data.security.auth.UserAuthorityFactory;
import org.molgenis.data.support.QueryImpl;
import org.springframework.security.crypto.password.PasswordEncoder;

public class UserRepositoryDecorator
extends AbstractRepositoryDecorator<User> {
    private static final int BATCH_SIZE = 1000;
    private final UserAuthorityFactory userAuthorityFactory;
    private final DataService dataService;
    private final PasswordEncoder passwordEncoder;

    public UserRepositoryDecorator(Repository<User> delegateRepository, UserAuthorityFactory userAuthorityFactory, DataService dataService, PasswordEncoder passwordEncoder) {
        super(delegateRepository);
        this.userAuthorityFactory = Objects.requireNonNull(userAuthorityFactory);
        this.dataService = Objects.requireNonNull(dataService);
        this.passwordEncoder = Objects.requireNonNull(passwordEncoder);
    }

    public void add(User entity) {
        this.encodePassword(entity);
        this.delegate().add((Entity)entity);
        this.addSuperuserAuthority(entity);
    }

    public void update(User entity) {
        this.updatePassword(entity);
        this.delegate().update((Entity)entity);
        this.updateSuperuserAuthority(entity);
    }

    public Integer add(Stream<User> entities) {
        AtomicInteger count = new AtomicInteger();
        Iterators.partition(entities.iterator(), (int)1000).forEachRemaining(users -> {
            users.forEach(this::encodePassword);
            Integer batchCount = this.delegate().add(users.stream());
            count.addAndGet(batchCount);
            users.forEach(this::addSuperuserAuthority);
        });
        return count.get();
    }

    public void update(Stream<User> entities) {
        entities = entities.map(entity -> {
            this.updatePassword((User)((Object)entity));
            return entity;
        });
        this.delegate().update(entities);
    }

    private void updatePassword(User user) {
        String password;
        User currentUser = (User)this.findOneById(user.getId());
        String currentPassword = currentUser.getPassword();
        if (!currentPassword.equals(password = user.getPassword())) {
            password = this.passwordEncoder.encode((CharSequence)user.getPassword());
        }
        user.setPassword(password);
    }

    private void encodePassword(User user) {
        String password = user.getPassword();
        String encodedPassword = this.passwordEncoder.encode((CharSequence)password);
        user.setPassword(encodedPassword);
    }

    private void addSuperuserAuthority(User user) {
        Boolean isSuperuser = user.isSuperuser();
        if (isSuperuser != null && isSuperuser.booleanValue()) {
            UserAuthority userAuthority = (UserAuthority)this.userAuthorityFactory.create();
            userAuthority.setUser(user);
            userAuthority.setRole("ROLE_SU");
            this.dataService.add("sys_sec_UserAuthority", (Entity)userAuthority);
        }
    }

    private void updateSuperuserAuthority(User user) {
        UserAuthority suAuthority = (UserAuthority)this.dataService.findOne("sys_sec_UserAuthority", new QueryImpl().eq("User", (Object)user).and().eq("role", (Object)"ROLE_SU"), UserAuthority.class);
        Boolean isSuperuser = user.isSuperuser();
        if (isSuperuser != null && isSuperuser.booleanValue()) {
            if (suAuthority == null) {
                UserAuthority userAuthority = (UserAuthority)this.userAuthorityFactory.create();
                userAuthority.setUser(user);
                userAuthority.setRole("ROLE_SU");
                this.dataService.add("sys_sec_UserAuthority", (Entity)userAuthority);
            }
        } else if (suAuthority != null) {
            this.dataService.deleteById("sys_sec_UserAuthority", (Object)suAuthority.getId());
        }
    }

    public void delete(User entity) {
        this.deleteUserAuthoritiesAndGroupMember(entity);
        this.delegate().delete((Entity)entity);
    }

    public void delete(Stream<User> entities) {
        entities = entities.map(entity -> {
            this.deleteUserAuthoritiesAndGroupMember((User)((Object)entity));
            return entity;
        });
        this.delegate().delete(entities);
    }

    public void deleteById(Object id) {
        this.deleteUserAuthoritiesAndGroupMember((User)this.findOneById(id));
        this.delegate().deleteById(id);
    }

    public void deleteAll(Stream<Object> ids) {
        ids = ids.map(id -> {
            this.deleteUserAuthoritiesAndGroupMember((User)this.findOneById(id));
            return id;
        });
        this.delegate().deleteAll(ids);
    }

    private void deleteUserAuthoritiesAndGroupMember(User user) {
        Stream userAuthorities = this.dataService.findAll("sys_sec_UserAuthority", new QueryImpl().eq("User", (Object)user), UserAuthority.class);
        this.dataService.delete("sys_sec_UserAuthority", userAuthorities);
        Stream groupMembers = this.dataService.findAll("sys_sec_GroupMember", new QueryImpl().eq("User", (Object)user), GroupMember.class);
        this.dataService.delete("sys_sec_GroupMember", groupMembers);
    }

    public void deleteAll() {
        throw new UnsupportedOperationException("Deleting all users is not supported.");
    }
}

