/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.security.auth;

import java.util.Objects;
import org.molgenis.data.AbstractSystemRepositoryDecoratorFactory;
import org.molgenis.data.DataService;
import org.molgenis.data.Repository;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.security.auth.User;
import org.molgenis.data.security.auth.UserAuthorityFactory;
import org.molgenis.data.security.auth.UserMetaData;
import org.molgenis.data.security.auth.UserRepositoryDecorator;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class UserRepositoryDecoratorFactory
extends AbstractSystemRepositoryDecoratorFactory<User, UserMetaData> {
    private final UserAuthorityFactory userAuthorityFactory;
    private final DataService dataService;
    private final PasswordEncoder passwordEncoder;

    public UserRepositoryDecoratorFactory(UserMetaData userMetaData, UserAuthorityFactory userAuthorityFactory, DataService dataService, PasswordEncoder passwordEncoder) {
        super((SystemEntityType)userMetaData);
        this.userAuthorityFactory = Objects.requireNonNull(userAuthorityFactory);
        this.dataService = Objects.requireNonNull(dataService);
        this.passwordEncoder = Objects.requireNonNull(passwordEncoder);
    }

    public Repository<User> createDecoratedRepository(Repository<User> repository) {
        return new UserRepositoryDecorator(repository, this.userAuthorityFactory, this.dataService, this.passwordEncoder);
    }
}

