/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.security.meta;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.Fetch;
import org.molgenis.data.MolgenisDataAccessException;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.aggregation.AggregateQuery;
import org.molgenis.data.aggregation.AggregateResult;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.system.SystemEntityTypeRegistry;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.util.EntityUtils;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.PermissionService;
import org.molgenis.security.core.utils.SecurityUtils;

public class AttributeRepositorySecurityDecorator
extends AbstractRepositoryDecorator<Attribute> {
    private final SystemEntityTypeRegistry systemEntityTypeRegistry;
    private final PermissionService permissionService;

    public AttributeRepositorySecurityDecorator(Repository<Attribute> delegateRepository, SystemEntityTypeRegistry systemEntityTypeRegistry, PermissionService permissionService) {
        super(delegateRepository);
        this.systemEntityTypeRegistry = Objects.requireNonNull(systemEntityTypeRegistry);
        this.permissionService = Objects.requireNonNull(permissionService);
    }

    public long count() {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return this.delegate().count();
        }
        Stream<Attribute> attrs = StreamSupport.stream(this.delegate().spliterator(), false);
        return this.filterCountPermission(attrs).count();
    }

    public long count(Query<Attribute> q) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return this.delegate().count(q);
        }
        QueryImpl qWithoutLimitOffset = new QueryImpl(q);
        qWithoutLimitOffset.offset(0).pageSize(Integer.MAX_VALUE);
        Stream attrs = this.delegate().findAll((Query)qWithoutLimitOffset);
        return this.filterCountPermission(attrs).count();
    }

    public Stream<Attribute> findAll(Query<Attribute> q) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return this.delegate().findAll(q);
        }
        QueryImpl qWithoutLimitOffset = new QueryImpl(q);
        qWithoutLimitOffset.offset(0).pageSize(Integer.MAX_VALUE);
        Stream attrs = this.delegate().findAll((Query)qWithoutLimitOffset);
        Stream<Attribute> filteredAttrs = this.filterCountPermission(attrs);
        if (q.getOffset() > 0) {
            filteredAttrs = filteredAttrs.skip(q.getOffset());
        }
        if (q.getPageSize() > 0) {
            filteredAttrs = filteredAttrs.limit(q.getPageSize());
        }
        return filteredAttrs;
    }

    public Iterator<Attribute> iterator() {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return this.delegate().iterator();
        }
        Stream<Attribute> attrs = StreamSupport.stream(this.delegate().spliterator(), false);
        return this.filterCountPermission(attrs).iterator();
    }

    public void forEachBatched(Fetch fetch, Consumer<List<Attribute>> consumer, int batchSize) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            this.delegate().forEachBatched(fetch, consumer, batchSize);
        } else {
            FilteredConsumer filteredConsumer = new FilteredConsumer(consumer);
            this.delegate().forEachBatched(fetch, filteredConsumer::filter, batchSize);
        }
    }

    public Attribute findOne(Query<Attribute> q) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return (Attribute)this.delegate().findOne(q);
        }
        return this.filterReadPermission((Attribute)this.delegate().findOne(q));
    }

    public Attribute findOneById(Object id) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return (Attribute)this.delegate().findOneById(id);
        }
        return this.filterReadPermission((Attribute)this.delegate().findOneById(id));
    }

    public Attribute findOneById(Object id, Fetch fetch) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return (Attribute)this.delegate().findOneById(id, fetch);
        }
        return this.filterReadPermission((Attribute)this.delegate().findOneById(id, fetch));
    }

    public Stream<Attribute> findAll(Stream<Object> ids) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return this.delegate().findAll(ids);
        }
        return this.filterCountPermission(this.delegate().findAll(ids));
    }

    public Stream<Attribute> findAll(Stream<Object> ids, Fetch fetch) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return this.delegate().findAll(ids, fetch);
        }
        return this.filterCountPermission(this.delegate().findAll(ids, fetch));
    }

    public AggregateResult aggregate(AggregateQuery aggregateQuery) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return this.delegate().aggregate(aggregateQuery);
        }
        throw new MolgenisDataAccessException(String.format("Aggregation on entity [%s] not allowed", this.getName()));
    }

    public void update(Attribute attr) {
        this.validateUpdateAllowed(attr);
        this.delegate().update((Entity)attr);
    }

    public void update(Stream<Attribute> attrs) {
        this.delegate().update(attrs.filter(attr -> {
            this.validateUpdateAllowed((Attribute)attr);
            return true;
        }));
    }

    public void delete(Attribute attr) {
        this.validateDeleteAllowed(attr);
        this.delegate().delete((Entity)attr);
    }

    public void delete(Stream<Attribute> attrs) {
        attrs.forEach(this::delete);
    }

    public void deleteById(Object id) {
        Attribute attr = this.findOneById(id);
        this.delete(attr);
    }

    public void deleteAll(Stream<Object> ids) {
        this.delete(this.findAll(ids));
    }

    public void deleteAll() {
        this.delete(this.query().findAll());
    }

    public void add(Attribute attr) {
        this.delegate().add((Entity)attr);
    }

    public Integer add(Stream<Attribute> attrs) {
        return this.delegate().add(attrs);
    }

    private void validateUpdateAllowed(Attribute attr) {
        String attrIdentifier = attr.getIdentifier();
        Attribute systemAttr = this.systemEntityTypeRegistry.getSystemAttribute(attrIdentifier);
        if (systemAttr != null && !EntityUtils.equals((Attribute)attr, (Attribute)systemAttr)) {
            throw new MolgenisDataException(String.format("Updating system entity attribute [%s] is not allowed", attr.getName()));
        }
    }

    private void validateDeleteAllowed(Attribute attr) {
        String attrIdentifier = attr.getIdentifier();
        if (this.systemEntityTypeRegistry.hasSystemAttribute(attrIdentifier)) {
            throw new MolgenisDataException(String.format("Deleting system entity attribute [%s] is not allowed", attr.getName()));
        }
    }

    private Stream<Attribute> filterCountPermission(Stream<Attribute> attrs) {
        return this.filterPermission(attrs, Permission.COUNT);
    }

    private Attribute filterReadPermission(Attribute attr) {
        return attr != null ? (Attribute)this.filterCountPermission(Stream.of(attr)).findFirst().orElse(null) : null;
    }

    private Stream<Attribute> filterPermission(Stream<Attribute> attrs, Permission permission) {
        return attrs.filter(attr -> this.permissionService.hasPermissionOnEntityType(attr.getEntity().getId(), permission));
    }

    private class FilteredConsumer {
        private final Consumer<List<Attribute>> consumer;

        FilteredConsumer(Consumer<List<Attribute>> consumer) {
            this.consumer = Objects.requireNonNull(consumer);
        }

        public void filter(List<Attribute> attrs) {
            Stream filteredAttrs = AttributeRepositorySecurityDecorator.this.filterPermission(attrs.stream(), Permission.COUNT);
            this.consumer.accept(filteredAttrs.collect(Collectors.toList()));
        }
    }
}

