/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.security.meta;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Fetch;
import org.molgenis.data.MolgenisDataAccessException;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.aggregation.AggregateQuery;
import org.molgenis.data.aggregation.AggregateResult;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.system.SystemEntityTypeRegistry;
import org.molgenis.data.security.auth.GroupAuthority;
import org.molgenis.data.security.auth.UserAuthority;
import org.molgenis.data.security.util.SecurityDecoratorUtils;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.PermissionService;
import org.molgenis.security.core.utils.SecurityUtils;

public class EntityTypeRepositorySecurityDecorator
extends AbstractRepositoryDecorator<EntityType> {
    private final SystemEntityTypeRegistry systemEntityTypeRegistry;
    private final PermissionService permissionService;
    private final DataService dataService;

    public EntityTypeRepositorySecurityDecorator(Repository<EntityType> delegateRepository, SystemEntityTypeRegistry systemEntityTypeRegistry, PermissionService permissionService, DataService dataService) {
        super(delegateRepository);
        this.systemEntityTypeRegistry = Objects.requireNonNull(systemEntityTypeRegistry);
        this.permissionService = Objects.requireNonNull(permissionService);
        this.dataService = Objects.requireNonNull(dataService);
    }

    public long count() {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return this.delegate().count();
        }
        Stream<EntityType> EntityTypes = StreamSupport.stream(this.delegate().spliterator(), false);
        return this.filterCountPermission(EntityTypes).count();
    }

    public long count(Query<EntityType> q) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return this.delegate().count(q);
        }
        QueryImpl qWithoutLimitOffset = new QueryImpl(q);
        qWithoutLimitOffset.offset(0).pageSize(Integer.MAX_VALUE);
        Stream EntityTypes = this.delegate().findAll((Query)qWithoutLimitOffset);
        return this.filterCountPermission(EntityTypes).count();
    }

    public Stream<EntityType> findAll(Query<EntityType> q) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return this.delegate().findAll(q);
        }
        QueryImpl qWithoutLimitOffset = new QueryImpl(q);
        qWithoutLimitOffset.offset(0).pageSize(Integer.MAX_VALUE);
        Stream EntityTypes = this.delegate().findAll((Query)qWithoutLimitOffset);
        Stream<EntityType> filteredEntityTypes = this.filterCountPermission(EntityTypes);
        if (q.getOffset() > 0) {
            filteredEntityTypes = filteredEntityTypes.skip(q.getOffset());
        }
        if (q.getPageSize() > 0) {
            filteredEntityTypes = filteredEntityTypes.limit(q.getPageSize());
        }
        return filteredEntityTypes;
    }

    public Iterator<EntityType> iterator() {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return this.delegate().iterator();
        }
        Stream<EntityType> EntityTypeStream = StreamSupport.stream(this.delegate().spliterator(), false);
        return this.filterCountPermission(EntityTypeStream).iterator();
    }

    public void forEachBatched(Fetch fetch, Consumer<List<EntityType>> consumer, int batchSize) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            this.delegate().forEachBatched(fetch, consumer, batchSize);
        } else {
            FilteredConsumer filteredConsumer = new FilteredConsumer(consumer, this.permissionService);
            this.delegate().forEachBatched(fetch, filteredConsumer::filter, batchSize);
        }
    }

    public EntityType findOne(Query<EntityType> q) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return (EntityType)this.delegate().findOne(q);
        }
        return this.filterCountPermission((EntityType)this.delegate().findOne(q));
    }

    public EntityType findOneById(Object id) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return (EntityType)this.delegate().findOneById(id);
        }
        return this.filterCountPermission((EntityType)this.delegate().findOneById(id));
    }

    public EntityType findOneById(Object id, Fetch fetch) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return (EntityType)this.delegate().findOneById(id, fetch);
        }
        return this.filterCountPermission((EntityType)this.delegate().findOneById(id, fetch));
    }

    public Stream<EntityType> findAll(Stream<Object> ids) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return this.delegate().findAll(ids);
        }
        return this.filterCountPermission(this.delegate().findAll(ids));
    }

    public Stream<EntityType> findAll(Stream<Object> ids, Fetch fetch) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return this.delegate().findAll(ids, fetch);
        }
        return this.filterCountPermission(this.delegate().findAll(ids, fetch));
    }

    public AggregateResult aggregate(AggregateQuery aggregateQuery) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return this.delegate().aggregate(aggregateQuery);
        }
        throw new MolgenisDataAccessException(String.format("Aggregation on entity [%s] not allowed", this.getName()));
    }

    public void update(EntityType entity) {
        this.validateUpdateAllowed(entity);
        super.update((Entity)entity);
    }

    public void update(Stream<EntityType> entities) {
        super.update(entities.filter(entityType -> {
            this.validateUpdateAllowed((EntityType)entityType);
            return true;
        }));
    }

    public void delete(EntityType entity) {
        this.validateDeleteAllowed(entity);
        this.deleteEntityPermissions(entity);
        super.delete((Entity)entity);
    }

    public void delete(Stream<EntityType> entities) {
        super.delete(entities.filter(entityType -> {
            this.validateDeleteAllowed((EntityType)entityType);
            this.deleteEntityPermissions((EntityType)entityType);
            return true;
        }));
    }

    public void deleteById(Object id) {
        this.validateDeleteAllowed(id);
        this.deleteEntityPermissions(id.toString());
        super.deleteById(id);
    }

    public void deleteAll(Stream<Object> ids) {
        super.deleteAll(ids.filter(id -> {
            this.validateDeleteAllowed(id);
            this.deleteEntityPermissions(id.toString());
            return true;
        }));
    }

    public void deleteAll() {
        this.iterator().forEachRemaining(entityType -> {
            this.validateDeleteAllowed((EntityType)entityType);
            this.deleteEntityPermissions((EntityType)entityType);
        });
        super.deleteAll();
    }

    private void deleteEntityPermissions(EntityType entityType) {
        this.deleteEntityPermissions(entityType.getId());
    }

    private void deleteEntityPermissions(String entityTypeId) {
        List groupPermissions;
        List authorities = SecurityUtils.getEntityAuthorities((String)entityTypeId);
        List userPermissions = this.dataService.query("sys_sec_UserAuthority", UserAuthority.class).in("role", (Iterable)authorities).findAll().collect(Collectors.toList());
        if (!userPermissions.isEmpty()) {
            this.dataService.delete("sys_sec_UserAuthority", userPermissions.stream());
        }
        if (!(groupPermissions = this.dataService.query("sys_sec_GroupAuthority", GroupAuthority.class).in("role", (Iterable)authorities).findAll().collect(Collectors.toList())).isEmpty()) {
            this.dataService.delete("sys_sec_GroupAuthority", groupPermissions.stream());
        }
    }

    public void add(EntityType entity) {
        this.validateAddAllowed(entity);
        super.add((Entity)entity);
    }

    public Integer add(Stream<EntityType> entities) {
        return super.add(entities.filter(entityType -> {
            this.validateAddAllowed((EntityType)entityType);
            return true;
        }));
    }

    private void validateAddAllowed(EntityType entityType) {
        SecurityDecoratorUtils.validatePermission(entityType, Permission.WRITEMETA);
    }

    private void validateUpdateAllowed(EntityType entityType) {
        SecurityDecoratorUtils.validatePermission(entityType, Permission.WRITEMETA);
        boolean isSystem = this.systemEntityTypeRegistry.hasSystemEntityType(entityType.getId());
        if (isSystem && !SecurityUtils.currentUserIsSystem()) {
            throw new MolgenisDataException(String.format("Updating system entity meta data [%s] is not allowed", entityType.getLabel()));
        }
    }

    private void validateDeleteAllowed(EntityType entityType) {
        SecurityDecoratorUtils.validatePermission(entityType, Permission.WRITEMETA);
        String entityTypeId = entityType.getId();
        boolean isSystem = this.systemEntityTypeRegistry.hasSystemEntityType(entityTypeId);
        if (isSystem) {
            throw new MolgenisDataException(String.format("Deleting system entity meta data [%s] is not allowed", entityTypeId));
        }
    }

    private void validateDeleteAllowed(Object entityTypeId) {
        EntityType entityType = this.findOneById(entityTypeId);
        if (entityType == null) {
            throw new UnknownEntityException(String.format("Unknown entity meta data [%s] with id [%s]", this.getName(), entityTypeId.toString()));
        }
        this.validateDeleteAllowed(entityType);
    }

    private EntityType filterCountPermission(EntityType entityType) {
        return entityType != null ? (EntityType)this.filterCountPermission(Stream.of(entityType)).findFirst().orElse(null) : null;
    }

    private Stream<EntityType> filterCountPermission(Stream<EntityType> EntityTypeStream) {
        return this.filterPermission(EntityTypeStream, Permission.COUNT);
    }

    private Stream<EntityType> filterPermission(Stream<EntityType> EntityTypeStream, Permission permission) {
        return EntityTypeStream.filter(entityType -> this.permissionService.hasPermissionOnEntityType(entityType.getId(), permission));
    }

    private static class FilteredConsumer {
        private final Consumer<List<EntityType>> consumer;
        private final PermissionService permissionService;

        FilteredConsumer(Consumer<List<EntityType>> consumer, PermissionService permissionService) {
            this.consumer = Objects.requireNonNull(consumer);
            this.permissionService = Objects.requireNonNull(permissionService);
        }

        void filter(List<EntityType> entityTypes) {
            List filteredEntityTypes = entityTypes.stream().filter((? super T entityType) -> this.permissionService.hasPermissionOnEntityType(entityType.getId(), Permission.COUNT)).collect(Collectors.toList());
            this.consumer.accept(filteredEntityTypes);
        }
    }
}

