/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class HugeMap<K, V>
implements Map<K, V>,
Closeable {
    protected static final int THRESHOLD = 10000;
    private DB mapDB;
    private Map<K, V> map;
    private final Map<K, V> hashMap = new HashMap();

    @Override
    public int size() {
        if (this.map == null) {
            return this.hashMap.size();
        }
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.map == null) {
            return this.hashMap.isEmpty();
        }
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.map == null) {
            return this.hashMap.containsKey(key);
        }
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.map == null) {
            return this.hashMap.containsValue(value);
        }
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        if (this.map == null) {
            return this.hashMap.get(key);
        }
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        if (this.hashMap.size() == 10000) {
            File dbFile;
            try {
                dbFile = File.createTempFile("mapdb", "temp");
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.mapDB = DBMaker.newFileDB((File)dbFile).deleteFilesAfterClose().transactionDisable().make();
            this.map = this.mapDB.createHashMap("map").make();
            this.map.putAll(this.hashMap);
            this.hashMap.clear();
        }
        if (this.map == null) {
            return this.hashMap.put(key, value);
        }
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        if (this.map == null) {
            return this.hashMap.remove(key);
        }
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        if (this.map == null) {
            this.hashMap.clear();
        } else {
            this.map.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        if (this.map == null) {
            return this.hashMap.keySet();
        }
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        if (this.map == null) {
            return this.hashMap.values();
        }
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.map == null) {
            return this.hashMap.entrySet();
        }
        return this.map.entrySet();
    }

    @Override
    public void close() throws IOException {
        if (this.mapDB != null) {
            this.mapDB.close();
        }
    }
}

