/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

public class ZipFileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ZipFileUtil.class);

    private ZipFileUtil() {
    }

    public static List<File> unzip(File file) throws IOException {
        ArrayList<File> unzippedFiles = new ArrayList<File>();
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.getName().startsWith(".") || entry.getName().startsWith("_")) continue;
                if (entry.isDirectory()) {
                    LOG.info("Extracting directory: " + entry.getName());
                    if (new File(file.getParentFile(), entry.getName()).mkdir()) continue;
                    throw new RuntimeException("Failed to create directory");
                }
                LOG.info("Extracting directory: " + entry.getName());
                File newFile = new File(file.getParent(), entry.getName());
                try (InputStream in = zipFile.getInputStream(entry);
                     BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newFile));){
                    StreamUtils.copy((InputStream)in, (OutputStream)out);
                }
                unzippedFiles.add(newFile);
            }
        }
        return unzippedFiles;
    }
}

