/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util.mail;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.mail.MessagingException;
import org.molgenis.util.mail.MailSenderFactory;
import org.molgenis.util.mail.MailSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.stereotype.Component;

@Component
public class JavaMailSenderFactory
implements MailSenderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JavaMailSenderFactory.class);
    private static Properties defaultProperties = new Properties();

    public JavaMailSenderImpl createMailSender(MailSettings mailSettings) {
        LOG.trace("createMailSender");
        if (mailSettings.getUsername() == null || mailSettings.getPassword() == null) {
            throw new IllegalStateException("Cannot create mail sender. Username or password of the mail account not specified in the system mail settings.");
        }
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(mailSettings.getHost());
        mailSender.setPort(mailSettings.getPort());
        mailSender.setProtocol(mailSettings.getProtocol());
        mailSender.setUsername(mailSettings.getUsername());
        mailSender.setPassword(mailSettings.getPassword());
        mailSender.setDefaultEncoding(mailSettings.getDefaultEncoding().name());
        Properties properties = new Properties(defaultProperties);
        properties.putAll((Map<?, ?>)mailSettings.getJavaMailProperties());
        LOG.debug("Mail properties: {}; defaults: {}", (Object)properties, (Object)defaultProperties);
        mailSender.setJavaMailProperties(properties);
        return mailSender;
    }

    @Override
    public void validateConnection(MailSettings mailSettings) {
        LOG.info("Validating mail settings...");
        try {
            JavaMailSenderImpl sender = this.createMailSender(mailSettings);
            sender.testConnection();
            LOG.info("OK.");
        }
        catch (MessagingException ex) {
            String message = String.format("Unable to ping to %s", mailSettings.getHost());
            LOG.info(message, (Throwable)ex);
            throw new IllegalStateException(message, ex);
        }
    }

    static {
        try {
            defaultProperties.load(JavaMailSenderFactory.class.getResourceAsStream("mail-default.properties"));
        }
        catch (IOException e) {
            throw new IllegalStateException("Default mail-default.properties not found!");
        }
    }
}

