/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util.mail;

import java.util.Objects;
import org.molgenis.util.mail.MailSenderFactory;
import org.molgenis.util.mail.MailSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.stereotype.Component;

@Component
public class MailSenderImpl
implements MailSender {
    private static final Logger LOG = LoggerFactory.getLogger(MailSenderImpl.class);
    private final MailSettings mailSettings;
    private final MailSenderFactory mailSenderFactory;

    public MailSenderImpl(MailSettings mailSettings, MailSenderFactory mailSenderFactory) {
        this.mailSettings = Objects.requireNonNull(mailSettings);
        this.mailSenderFactory = Objects.requireNonNull(mailSenderFactory);
    }

    public void send(SimpleMailMessage simpleMessage) {
        LOG.trace("Sending message...");
        this.createMailSender().send(simpleMessage);
        LOG.debug("Sent message.");
    }

    public void send(SimpleMailMessage ... simpleMessages) {
        LOG.trace("Sending messages...");
        this.createMailSender().send(simpleMessages);
        LOG.debug("Sent messages.");
    }

    private MailSender createMailSender() {
        return this.mailSenderFactory.createMailSender(this.mailSettings);
    }
}

