/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.vault;

import com.mongodb.Block;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.Observables;
import com.mongodb.client.model.vault.DataKeyOptions;
import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.reactivestreams.client.internal.ObservableToPublisher;
import com.mongodb.reactivestreams.client.vault.ClientEncryption;
import org.bson.BsonBinary;
import org.bson.BsonValue;
import org.reactivestreams.Publisher;

class ClientEncryptionImpl
implements ClientEncryption {
    private final com.mongodb.async.client.vault.ClientEncryption wrapped;

    public ClientEncryptionImpl(com.mongodb.async.client.vault.ClientEncryption wrapped) {
        this.wrapped = (com.mongodb.async.client.vault.ClientEncryption)Assertions.notNull((String)"wrapped", (Object)wrapped);
    }

    @Override
    public Publisher<BsonBinary> createDataKey(String kmsProvider) {
        return this.createDataKey(kmsProvider, new DataKeyOptions());
    }

    @Override
    public Publisher<BsonBinary> createDataKey(final String kmsProvider, final DataKeyOptions dataKeyOptions) {
        return new ObservableToPublisher<BsonBinary>(Observables.observe((Block)new Block<SingleResultCallback<BsonBinary>>(){

            public void apply(SingleResultCallback<BsonBinary> callback) {
                ClientEncryptionImpl.this.wrapped.createDataKey(kmsProvider, dataKeyOptions, callback);
            }
        }));
    }

    @Override
    public Publisher<BsonBinary> encrypt(final BsonValue value, final EncryptOptions options) {
        return new ObservableToPublisher<BsonBinary>(Observables.observe((Block)new Block<SingleResultCallback<BsonBinary>>(){

            public void apply(SingleResultCallback<BsonBinary> callback) {
                ClientEncryptionImpl.this.wrapped.encrypt(value, options, callback);
            }
        }));
    }

    @Override
    public Publisher<BsonValue> decrypt(final BsonBinary value) {
        return new ObservableToPublisher<BsonValue>(Observables.observe((Block)new Block<SingleResultCallback<BsonValue>>(){

            public void apply(SingleResultCallback<BsonValue> callback) {
                ClientEncryptionImpl.this.wrapped.decrypt(value, callback);
            }
        }));
    }

    @Override
    public void close() {
        this.wrapped.close();
    }
}

