/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.gridfs;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.MongoClient;
import com.mongodb.MongoGridFSException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

class GridFSFindIterableImpl
implements GridFSFindIterable {
    private static final CodecRegistry DEFAULT_CODEC_REGISTRY = MongoClient.getDefaultCodecRegistry();
    private final FindIterable<Document> underlying;
    private static final List<String> VALID_FIELDS = Arrays.asList("_id", "filename", "length", "chunkSize", "uploadDate", "md5", "metadata");

    public GridFSFindIterableImpl(FindIterable<Document> underlying) {
        this.underlying = underlying;
    }

    @Override
    public GridFSFindIterable sort(Bson sort) {
        this.underlying.sort(sort);
        return this;
    }

    @Override
    public GridFSFindIterable skip(int skip) {
        this.underlying.skip(skip);
        return this;
    }

    @Override
    public GridFSFindIterable limit(int limit) {
        this.underlying.limit(limit);
        return this;
    }

    @Override
    public GridFSFindIterable filter(Bson filter) {
        this.underlying.filter(filter);
        return this;
    }

    @Override
    public GridFSFindIterable maxTime(long maxTime, TimeUnit timeUnit) {
        this.underlying.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public GridFSFindIterable batchSize(int batchSize) {
        this.underlying.batchSize(batchSize);
        return this;
    }

    @Override
    public GridFSFindIterable noCursorTimeout(boolean noCursorTimeout) {
        this.underlying.noCursorTimeout(noCursorTimeout);
        return this;
    }

    @Override
    public MongoCursor<GridFSFile> iterator() {
        return this.toGridFSFileIterable().iterator();
    }

    @Override
    public GridFSFile first() {
        return this.toGridFSFileIterable().first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<GridFSFile, U> mapper) {
        return this.toGridFSFileIterable().map(mapper);
    }

    @Override
    public void forEach(Block<? super GridFSFile> block) {
        this.toGridFSFileIterable().forEach(block);
    }

    @Override
    public <A extends Collection<? super GridFSFile>> A into(A target) {
        return this.toGridFSFileIterable().into(target);
    }

    private MongoIterable<GridFSFile> toGridFSFileIterable() {
        return this.underlying.map(new Function<Document, GridFSFile>(){

            public GridFSFile apply(Document document) {
                BsonValue id = GridFSFindIterableImpl.this.getId(document);
                String filename = document.getString((Object)"filename");
                long length = GridFSFindIterableImpl.this.getAndValidateNumber("length", document).longValue();
                int chunkSize = GridFSFindIterableImpl.this.getAndValidateNumber("chunkSize", document).intValue();
                Date uploadDate = document.getDate((Object)"uploadDate");
                String md5 = document.getString((Object)"md5");
                Document metadata = (Document)document.get((Object)"metadata", Document.class);
                HashSet extraElementKeys = new HashSet(document.keySet());
                extraElementKeys.removeAll(VALID_FIELDS);
                if (extraElementKeys.size() > 0) {
                    Document extraElements = new Document();
                    for (String key : extraElementKeys) {
                        extraElements.append(key, document.get((Object)key));
                    }
                    return new GridFSFile(id, filename, length, chunkSize, uploadDate, md5, metadata, extraElements);
                }
                return new GridFSFile(id, filename, length, chunkSize, uploadDate, md5, metadata);
            }
        });
    }

    private Number getAndValidateNumber(String fieldName, Document document) {
        Number value = (Number)document.get((Object)fieldName, Number.class);
        if (value.floatValue() % 1.0f != 0.0f) {
            throw new MongoGridFSException(String.format("Invalid number format for %s", fieldName));
        }
        return value;
    }

    private BsonValue getId(Document document) {
        Object rawId = document.get((Object)"_id");
        if (rawId instanceof ObjectId) {
            return new BsonObjectId((ObjectId)rawId);
        }
        return new Document("_id", document.get((Object)"_id")).toBsonDocument(BsonDocument.class, DEFAULT_CODEC_REGISTRY).get((Object)"_id");
    }
}

