/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class JettyStopMojo
extends AbstractMojo {
    protected int stopPort;
    protected String stopKey;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.stopPort <= 0) {
            throw new MojoExecutionException("Please specify a valid port");
        }
        if (this.stopKey == null) {
            throw new MojoExecutionException("Please specify a valid stopKey");
        }
        try {
            Socket s = new Socket(InetAddress.getByName("127.0.0.1"), this.stopPort);
            s.setSoLinger(false, 0);
            OutputStream out = s.getOutputStream();
            out.write((this.stopKey + "\r\nstop\r\n").getBytes());
            out.flush();
            s.close();
        }
        catch (ConnectException e) {
            this.getLog().info((CharSequence)"Jetty not running!");
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
    }

    public int getStopPort() {
        return this.stopPort;
    }

    public void setStopPort(int stopPort) {
        this.stopPort = stopPort;
    }

    public String getStopKey() {
        return this.stopKey;
    }

    public void setStopKey(String stopKey) {
        this.stopKey = stopKey;
    }
}

