/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import java.util.ArrayList;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleUtils;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.execution.MessageProcessContext;
import org.mule.execution.MessageProcessTemplate;
import org.mule.execution.MessageProcessingManager;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.listener.HttpListener;
import org.mule.module.http.api.listener.HttpListenerConfig;
import org.mule.module.http.api.requester.HttpStreamingType;
import org.mule.module.http.internal.HttpParser;
import org.mule.module.http.internal.domain.ByteArrayHttpEntity;
import org.mule.module.http.internal.domain.request.HttpRequestContext;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.listener.DefaultHttpListenerConfig;
import org.mule.module.http.internal.listener.HttpMessageProcessContext;
import org.mule.module.http.internal.listener.HttpMessageProcessorTemplate;
import org.mule.module.http.internal.listener.HttpRequestParsingException;
import org.mule.module.http.internal.listener.HttpRequestToMuleEvent;
import org.mule.module.http.internal.listener.HttpResponseBuilder;
import org.mule.module.http.internal.listener.ListenerPath;
import org.mule.module.http.internal.listener.RequestHandlerManager;
import org.mule.module.http.internal.listener.async.HttpResponseReadyCallback;
import org.mule.module.http.internal.listener.async.RequestHandler;
import org.mule.module.http.internal.listener.async.ResponseStatusCallback;
import org.mule.module.http.internal.listener.matcher.AcceptsAllMethodsRequestMatcher;
import org.mule.module.http.internal.listener.matcher.ListenerRequestMatcher;
import org.mule.module.http.internal.listener.matcher.MethodRequestMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpListener
implements HttpListener,
Initialisable,
MuleContextAware,
FlowConstructAware {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHttpListener.class);
    public static final String SERVER_PROBLEM = "Server encountered a problem";
    private String path;
    private String allowedMethods;
    private Boolean parseRequest;
    private MessageProcessor messageProcessor;
    private MethodRequestMatcher methodRequestMatcher = AcceptsAllMethodsRequestMatcher.instance();
    private MuleContext muleContext;
    private FlowConstruct flowConstruct;
    private DefaultHttpListenerConfig config;
    private HttpResponseBuilder responseBuilder;
    private HttpResponseBuilder errorResponseBuilder;
    private HttpStreamingType responseStreamingMode = HttpStreamingType.AUTO;
    private RequestHandlerManager requestHandlerManager;
    private MessageProcessingManager messageProcessingManager;
    private String[] parsedAllowedMethods;
    private ListenerPath listenerPath;

    public void setListener(MessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setAllowedMethods(String allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    public void setConfig(DefaultHttpListenerConfig config) {
        this.config = config;
    }

    public void setResponseBuilder(HttpResponseBuilder responseBuilder) {
        this.responseBuilder = responseBuilder;
    }

    public void setErrorResponseBuilder(HttpResponseBuilder errorResponseBuilder) {
        this.errorResponseBuilder = errorResponseBuilder;
    }

    public void setResponseStreamingMode(HttpStreamingType responseStreamingMode) {
        this.responseStreamingMode = responseStreamingMode;
    }

    public void setParseRequest(boolean parseRequest) {
        this.parseRequest = parseRequest;
    }

    @Override
    public HttpListenerConfig getConfig() {
        return this.config;
    }

    @Override
    public synchronized void start() throws MuleException {
        this.requestHandlerManager.start();
    }

    private RequestHandler getRequestHandler() {
        return new RequestHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
                try {
                    HttpMessageProcessorTemplate httpMessageProcessorTemplate = new HttpMessageProcessorTemplate(DefaultHttpListener.this.createEvent(requestContext), DefaultHttpListener.this.messageProcessor, responseCallback, DefaultHttpListener.this.responseBuilder, DefaultHttpListener.this.errorResponseBuilder);
                    HttpMessageProcessContext messageProcessContext = new HttpMessageProcessContext(DefaultHttpListener.this, DefaultHttpListener.this.flowConstruct, DefaultHttpListener.this.config.getWorkManager(), DefaultHttpListener.this.muleContext.getExecutionClassLoader());
                    DefaultHttpListener.this.messageProcessingManager.processMessage((MessageProcessTemplate)httpMessageProcessorTemplate, (MessageProcessContext)messageProcessContext);
                }
                catch (IllegalArgumentException | HttpRequestParsingException e) {
                    logger.warn("Exception occurred parsing request:", (Throwable)e);
                    this.sendErrorResponse(HttpConstants.HttpStatus.BAD_REQUEST, e.getMessage(), responseCallback);
                }
                catch (RuntimeException e) {
                    logger.warn("Exception occurred processing request:", (Throwable)e);
                    this.sendErrorResponse(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR, DefaultHttpListener.SERVER_PROBLEM, responseCallback);
                }
                finally {
                    RequestContext.clear();
                }
            }

            private void sendErrorResponse(final HttpConstants.HttpStatus status, String message, HttpResponseReadyCallback responseCallback) {
                byte[] responseData = message.getBytes();
                HttpResponse response = new org.mule.module.http.internal.domain.response.HttpResponseBuilder().setStatusCode(status.getStatusCode()).setReasonPhrase(status.getReasonPhrase()).setEntity(new ByteArrayHttpEntity(responseData)).addHeader("Content-Length", Integer.toString(responseData.length)).build();
                responseCallback.responseReady(response, new ResponseStatusCallback(){

                    @Override
                    public void responseSendFailure(Throwable exception) {
                        logger.warn("Error while sending {} response {}", (Object)status.getStatusCode(), (Object)exception.getMessage());
                        if (logger.isDebugEnabled()) {
                            logger.debug("Exception thrown", exception);
                        }
                    }

                    @Override
                    public void responseSendSuccessfully() {
                    }
                });
            }
        };
    }

    private MuleEvent createEvent(HttpRequestContext requestContext) throws HttpRequestParsingException {
        MuleEvent muleEvent = HttpRequestToMuleEvent.transform(requestContext, this.muleContext, this.flowConstruct, this.parseRequest, this.listenerPath);
        OptimizedRequestContext.unsafeSetEvent((MuleEvent)muleEvent);
        return muleEvent;
    }

    public synchronized void initialise() throws InitialisationException {
        if (this.allowedMethods != null) {
            this.parsedAllowedMethods = this.extractAllowedMethods();
            this.methodRequestMatcher = new MethodRequestMatcher(this.parsedAllowedMethods);
        }
        if (this.responseBuilder == null) {
            this.responseBuilder = HttpResponseBuilder.emptyInstance(this.muleContext);
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.responseBuilder);
        if (this.errorResponseBuilder == null) {
            this.errorResponseBuilder = HttpResponseBuilder.emptyInstance(this.muleContext);
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.errorResponseBuilder);
        this.path = HttpParser.sanitizePathWithStartSlash(this.path);
        this.listenerPath = this.config.getFullListenerPath(this.path);
        this.path = this.listenerPath.getResolvedPath();
        this.responseBuilder.setResponseStreaming(this.responseStreamingMode);
        this.validatePath();
        this.parseRequest = this.config.resolveParseRequest(this.parseRequest);
        try {
            this.messageProcessingManager = (MessageProcessingManager)this.muleContext.getRegistry().lookupObject(MessageProcessingManager.class);
            this.requestHandlerManager = this.config.addRequestHandler(new ListenerRequestMatcher(this.methodRequestMatcher, this.path), this.getRequestHandler());
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    private void validatePath() throws InitialisationException {
        String[] pathParts = this.path.split("/");
        ArrayList<String> uriParamNames = new ArrayList<String>();
        for (String pathPart : pathParts) {
            if (pathPart.startsWith("{") && pathPart.endsWith("}")) {
                String uriParamName = pathPart.substring(1, pathPart.length() - 1);
                if (uriParamNames.contains(uriParamName)) {
                    throw new InitialisationException(CoreMessages.createStaticMessage((String)String.format("Http Listener with path %s contains duplicated uri param names", this.path)), (Initialisable)this);
                }
                uriParamNames.add(uriParamName);
                continue;
            }
            if (!pathPart.contains("*") || pathPart.length() <= 1) continue;
            throw new InitialisationException(CoreMessages.createStaticMessage((String)String.format("Http Listener with path %s contains an invalid use of a wildcard. Wildcards can only be used at the end of the path (i.e.: /path/*) or between / characters (.i.e.: /path/*/anotherPath))", this.path)), (Initialisable)this);
        }
    }

    private String[] extractAllowedMethods() throws InitialisationException {
        String[] values = this.allowedMethods.split(",");
        String[] normalizedValues = new String[values.length];
        int normalizedValueIndex = 0;
        for (String value : values) {
            normalizedValues[normalizedValueIndex] = value.trim().toUpperCase();
            ++normalizedValueIndex;
        }
        return normalizedValues;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    @Override
    public synchronized void stop() throws MuleException {
        this.requestHandlerManager.stop();
    }

    @Override
    public void dispose() {
        this.requestHandlerManager.dispose();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String[] getAllowedMethods() {
        return this.parsedAllowedMethods;
    }
}

