/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.config;

import java.util.HashMap;
import org.mule.config.spring.parsers.AbstractMuleBeanDefinitionParser;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.processors.ProvideDefaultNameFromElement;
import org.mule.module.management.agent.JmxAgentConfigurer;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JmxAgentDefinitionParser
extends AbstractMuleBeanDefinitionParser {
    public static final String CONNECTOR_SERVER = "connector-server";

    public JmxAgentDefinitionParser() {
        this.singleton = true;
        this.addAlias("server", "mBeanServer");
        this.registerPreProcessor((PreProcessor)new ProvideDefaultNameFromElement());
    }

    protected Class<?> getBeanClass(Element element) {
        return JmxAgentConfigurer.class;
    }

    protected void postProcess(ParserContext context, BeanAssembler assembler, Element element) {
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!CONNECTOR_SERVER.equals(node.getLocalName())) continue;
            assembler.extendBean("connectorServerUrl", (Object)((Element)node).getAttribute("url"), false);
            String rebind = ((Element)node).getAttribute("rebind");
            if (StringUtils.isEmpty((String)rebind)) continue;
            HashMap<String, String> csProps = new HashMap<String, String>();
            csProps.put("jmx.remote.jndi.rebind", rebind);
            assembler.extendBean("connectorServerProperties", csProps, false);
        }
        super.postProcess(context, assembler, element);
    }
}

