/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.guava.util.concurrent;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.nd4j.shade.errorprone.annotations.CanIgnoreReturnValue;
import org.nd4j.shade.guava.annotations.Beta;
import org.nd4j.shade.guava.annotations.GwtIncompatible;
import org.nd4j.shade.guava.util.concurrent.Internal;

@Beta
@GwtIncompatible
public interface TimeLimiter {
    public <T> T newProxy(T var1, Class<T> var2, long var3, TimeUnit var5);

    default public <T> T newProxy(T target, Class<T> interfaceType, Duration timeout) {
        return this.newProxy(target, interfaceType, Internal.saturatedToNanos(timeout), TimeUnit.NANOSECONDS);
    }

    @CanIgnoreReturnValue
    public <T> T callWithTimeout(Callable<T> var1, long var2, TimeUnit var4) throws TimeoutException, InterruptedException, ExecutionException;

    @CanIgnoreReturnValue
    default public <T> T callWithTimeout(Callable<T> callable, Duration timeout) throws TimeoutException, InterruptedException, ExecutionException {
        return this.callWithTimeout(callable, Internal.saturatedToNanos(timeout), TimeUnit.NANOSECONDS);
    }

    @CanIgnoreReturnValue
    public <T> T callUninterruptiblyWithTimeout(Callable<T> var1, long var2, TimeUnit var4) throws TimeoutException, ExecutionException;

    @CanIgnoreReturnValue
    default public <T> T callUninterruptiblyWithTimeout(Callable<T> callable, Duration timeout) throws TimeoutException, ExecutionException {
        return this.callUninterruptiblyWithTimeout(callable, Internal.saturatedToNanos(timeout), TimeUnit.NANOSECONDS);
    }

    public void runWithTimeout(Runnable var1, long var2, TimeUnit var4) throws TimeoutException, InterruptedException;

    default public void runWithTimeout(Runnable runnable, Duration timeout) throws TimeoutException, InterruptedException {
        this.runWithTimeout(runnable, Internal.saturatedToNanos(timeout), TimeUnit.NANOSECONDS);
    }

    public void runUninterruptiblyWithTimeout(Runnable var1, long var2, TimeUnit var4) throws TimeoutException;

    default public void runUninterruptiblyWithTimeout(Runnable runnable, Duration timeout) throws TimeoutException {
        this.runUninterruptiblyWithTimeout(runnable, Internal.saturatedToNanos(timeout), TimeUnit.NANOSECONDS);
    }
}

