/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.shade.jackson.dataformat.xml.ser;

import java.io.Closeable;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.nd4j.shade.jackson.core.JsonGenerator;
import org.nd4j.shade.jackson.databind.JavaType;
import org.nd4j.shade.jackson.databind.JsonMappingException;
import org.nd4j.shade.jackson.databind.JsonSerializer;
import org.nd4j.shade.jackson.databind.PropertyName;
import org.nd4j.shade.jackson.databind.SerializationConfig;
import org.nd4j.shade.jackson.databind.ser.DefaultSerializerProvider;
import org.nd4j.shade.jackson.databind.ser.SerializerFactory;
import org.nd4j.shade.jackson.databind.util.TokenBuffer;
import org.nd4j.shade.jackson.dataformat.xml.ser.ToXmlGenerator;
import org.nd4j.shade.jackson.dataformat.xml.util.StaxUtil;
import org.nd4j.shade.jackson.dataformat.xml.util.TypeUtil;
import org.nd4j.shade.jackson.dataformat.xml.util.XmlRootNameLookup;

public class XmlSerializerProvider
extends DefaultSerializerProvider {
    private static final long serialVersionUID = 1L;
    protected static final QName ROOT_NAME_FOR_NULL = new QName("null");
    protected final XmlRootNameLookup _rootNameLookup;

    public XmlSerializerProvider(XmlRootNameLookup rootNames) {
        this._rootNameLookup = rootNames;
    }

    public XmlSerializerProvider(XmlSerializerProvider src, SerializationConfig config, SerializerFactory f) {
        super(src, config, f);
        this._rootNameLookup = src._rootNameLookup;
    }

    protected XmlSerializerProvider(XmlSerializerProvider src) {
        super(src);
        this._rootNameLookup = new XmlRootNameLookup();
    }

    @Override
    public DefaultSerializerProvider copy() {
        return new XmlSerializerProvider(this);
    }

    @Override
    public DefaultSerializerProvider createInstance(SerializationConfig config, SerializerFactory jsf) {
        return new XmlSerializerProvider(this, config, jsf);
    }

    @Override
    public void serializeValue(JsonGenerator gen, Object value) throws IOException {
        boolean asArray;
        if (value == null) {
            this._serializeXmlNull(gen);
            return;
        }
        Class<?> cls = value.getClass();
        ToXmlGenerator xgen = this._asXmlGenerator(gen);
        if (xgen == null) {
            asArray = false;
        } else {
            QName rootName = this._rootNameFromConfig();
            if (rootName == null) {
                rootName = this._rootNameLookup.findRootName(cls, this._config);
            }
            this._initWithRootName(xgen, rootName);
            asArray = TypeUtil.isIndexedType(cls);
            if (asArray) {
                this._startRootArray(xgen, rootName);
            }
        }
        JsonSerializer<Object> ser = this.findTypedValueSerializer(cls, true, null);
        try {
            ser.serialize(value, gen, this);
        }
        catch (Exception e) {
            throw this._wrapAsIOE(gen, e);
        }
        if (asArray) {
            gen.writeEndObject();
        }
    }

    @Override
    public void serializeValue(JsonGenerator gen, Object value, JavaType rootType, JsonSerializer<Object> ser) throws IOException {
        boolean asArray;
        if (value == null) {
            this._serializeXmlNull(gen);
            return;
        }
        ToXmlGenerator xgen = this._asXmlGenerator(gen);
        if (xgen == null) {
            asArray = false;
        } else {
            QName rootName = this._rootNameFromConfig();
            if (rootName == null) {
                rootName = this._rootNameLookup.findRootName(rootType, this._config);
            }
            this._initWithRootName(xgen, rootName);
            asArray = TypeUtil.isIndexedType(rootType);
            if (asArray) {
                this._startRootArray(xgen, rootName);
            }
        }
        if (ser == null) {
            ser = this.findTypedValueSerializer(rootType, true, null);
        }
        try {
            ser.serialize(value, gen, this);
        }
        catch (Exception e) {
            throw this._wrapAsIOE(gen, e);
        }
        if (asArray) {
            gen.writeEndObject();
        }
    }

    protected void _serializeXmlNull(JsonGenerator jgen) throws IOException {
        QName rootName = this._rootNameFromConfig();
        if (rootName == null) {
            rootName = ROOT_NAME_FOR_NULL;
        }
        if (jgen instanceof ToXmlGenerator) {
            this._initWithRootName((ToXmlGenerator)jgen, rootName);
        }
        super.serializeValue(jgen, null);
    }

    protected void _startRootArray(ToXmlGenerator xgen, QName rootName) throws IOException {
        xgen.writeStartObject();
        xgen.writeFieldName("item");
    }

    protected void _initWithRootName(ToXmlGenerator xgen, QName rootName) throws IOException {
        if (!xgen.setNextNameIfMissing(rootName) && xgen.inRoot()) {
            xgen.setNextName(rootName);
        }
        xgen.initGenerator();
        String ns = rootName.getNamespaceURI();
        if (ns != null && ns.length() > 0) {
            try {
                xgen.getStaxWriter().setDefaultNamespace(ns);
            }
            catch (XMLStreamException e) {
                StaxUtil.throwAsGenerationException(e, xgen);
            }
        }
    }

    protected QName _rootNameFromConfig() {
        PropertyName name = this._config.getFullRootName();
        if (name == null) {
            return null;
        }
        String ns = name.getNamespace();
        if (ns == null || ns.isEmpty()) {
            return new QName(name.getSimpleName());
        }
        return new QName(ns, name.getSimpleName());
    }

    protected ToXmlGenerator _asXmlGenerator(JsonGenerator gen) throws JsonMappingException {
        if (!(gen instanceof ToXmlGenerator)) {
            if (!(gen instanceof TokenBuffer)) {
                throw JsonMappingException.from(gen, "XmlMapper does not with generators of type other than ToXmlGenerator; got: " + gen.getClass().getName());
            }
            return null;
        }
        return (ToXmlGenerator)gen;
    }

    protected IOException _wrapAsIOE(JsonGenerator g, Exception e) {
        if (e instanceof IOException) {
            return (IOException)e;
        }
        String msg = e.getMessage();
        if (msg == null) {
            msg = "[no message for " + e.getClass().getName() + "]";
        }
        return new JsonMappingException((Closeable)g, msg, (Throwable)e);
    }
}

