/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.activations.impl;

import lombok.NonNull;
import org.nd4j.linalg.activations.BaseActivationFunction;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.Cube;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.CubeDerivative;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;

public class ActivationCube
extends BaseActivationFunction {
    @Override
    public INDArray getActivation(INDArray in, boolean training) {
        Nd4j.getExecutioner().execAndReturn(new Cube(in));
        return in;
    }

    @Override
    public Pair<INDArray, INDArray> backprop(@NonNull INDArray in, @NonNull INDArray epsilon) {
        if (in == null) {
            throw new NullPointerException("in is marked @NonNull but is null");
        }
        if (epsilon == null) {
            throw new NullPointerException("epsilon is marked @NonNull but is null");
        }
        this.assertShape(in, epsilon);
        INDArray dLdz = Nd4j.getExecutioner().execAndReturn(new CubeDerivative(in));
        dLdz.muli(epsilon);
        return new Pair((Object)dLdz, null);
    }

    public String toString() {
        return "cube";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivationCube)) {
            return false;
        }
        ActivationCube other = (ActivationCube)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActivationCube;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }
}

