/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.aggregates;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ops.aggregates.Aggregate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Batch<T extends Aggregate> {
    private static final Logger log = LoggerFactory.getLogger(Batch.class);
    private DataBuffer paramsSurface;
    private static final int batchLimit = 512;
    private List<T> aggregates;
    private T sample;
    private int numAggregates;

    public Batch(List<T> aggregates) {
        this.aggregates = aggregates;
        this.numAggregates = aggregates.size();
        this.sample = (Aggregate)aggregates.get(0);
    }

    public int opNum() {
        return this.sample.opNum();
    }

    public boolean append(T aggregate) {
        if (!this.isFull()) {
            this.aggregates.add(aggregate);
            return true;
        }
        return false;
    }

    public boolean isFull() {
        return 512 == this.numAggregates;
    }

    public static <U extends Aggregate> List<Batch<U>> getBatches(List<U> list) {
        return Batch.getBatches(list, 512);
    }

    public static <U extends Aggregate> List<Batch<U>> getBatches(List<U> list, int partitionSize) {
        List partitions = Lists.partition(list, (int)partitionSize);
        ArrayList<Batch<U>> split = new ArrayList<Batch<U>>();
        for (List partition : partitions) {
            split.add(new Batch(partition));
        }
        return split;
    }

    public DataBuffer getParamsSurface() {
        return this.paramsSurface;
    }

    public void setParamsSurface(DataBuffer paramsSurface) {
        this.paramsSurface = paramsSurface;
    }

    public static int getBatchLimit() {
        return 512;
    }

    public List<T> getAggregates() {
        return this.aggregates;
    }

    public T getSample() {
        return this.sample;
    }

    public int getNumAggregates() {
        return this.numAggregates;
    }
}

