/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class StridedSlice
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(StridedSlice.class);
    private long[] begin;
    private long[] end;
    private long[] strides;
    private int beginMask;
    private int endMask;
    private int ellipsisMask;
    private int newAxisMask;
    private int shrinkAxisMask;

    public StridedSlice() {
    }

    public StridedSlice(SameDiff sameDiff, SDVariable in, int[] begin, int[] end, int[] strides) {
        this(sameDiff, in, begin, end, strides, 0, 0, 0, 0, 0);
    }

    public StridedSlice(SameDiff sameDiff, SDVariable in, long[] begin, long[] end, long[] strides) {
        this(sameDiff, in, begin, end, strides, 0, 0, 0, 0, 0);
    }

    public StridedSlice(SameDiff sameDiff, SDVariable in, @NonNull long[] begin, @NonNull long[] end, @NonNull long[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        super(null, sameDiff, new SDVariable[]{in});
        if (begin == null) {
            throw new NullPointerException("begin is marked @NonNull but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked @NonNull but is null");
        }
        if (strides == null) {
            throw new NullPointerException("strides is marked @NonNull but is null");
        }
        this.begin = begin;
        this.end = end;
        this.strides = strides;
        this.beginMask = beginMask;
        this.endMask = endMask;
        this.ellipsisMask = ellipsisMask;
        this.newAxisMask = newAxisMask;
        this.shrinkAxisMask = shrinkAxisMask;
        this.addArguments();
    }

    public StridedSlice(SameDiff sameDiff, SDVariable in, @NonNull int[] begin, @NonNull int[] end, @NonNull int[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        super(null, sameDiff, new SDVariable[]{in});
        if (begin == null) {
            throw new NullPointerException("begin is marked @NonNull but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked @NonNull but is null");
        }
        if (strides == null) {
            throw new NullPointerException("strides is marked @NonNull but is null");
        }
        this.begin = ArrayUtil.toLongArray((int[])begin);
        this.end = ArrayUtil.toLongArray((int[])end);
        this.strides = ArrayUtil.toLongArray((int[])strides);
        this.beginMask = beginMask;
        this.endMask = endMask;
        this.ellipsisMask = ellipsisMask;
        this.newAxisMask = newAxisMask;
        this.shrinkAxisMask = shrinkAxisMask;
        this.addArguments();
    }

    private void addArguments() {
        this.addIArgument(this.beginMask);
        this.addIArgument(this.ellipsisMask);
        this.addIArgument(this.endMask);
        this.addIArgument(this.newAxisMask);
        this.addIArgument(this.shrinkAxisMask);
        this.addIArgument(this.begin);
        this.addIArgument(this.end);
        this.addIArgument(this.strides);
    }

    @Override
    public String opName() {
        return "stridedslice";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "StridedSlice";
    }

    @Override
    public void assertValidForExecution() {
        if (this.numInputArguments() != 1 && this.numInputArguments() != 3 && this.numInputArguments() != 4) {
            throw new ND4JIllegalStateException("Num input arguments must be 1 3 or 4.");
        }
        if (this.numIArguments() < 5) {
            throw new ND4JIllegalStateException("Number of integer arguments must >= 5");
        }
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        String inputBegin = nodeDef.getInput(1);
        String inputEnd = nodeDef.getInput(2);
        String inputStrides = nodeDef.getInput(3);
        NodeDef beginNode = null;
        NodeDef endNode = null;
        NodeDef strides = null;
        for (int i = 0; i < graph.getNodeCount(); ++i) {
            if (graph.getNode(i).getName().equals(inputBegin)) {
                beginNode = graph.getNode(i);
            }
            if (graph.getNode(i).getName().equals(inputEnd)) {
                endNode = graph.getNode(i);
            }
            if (!graph.getNode(i).getName().equals(inputStrides)) continue;
            strides = graph.getNode(i);
        }
        AttrValue bm = nodeDef.getAttrOrThrow("begin_mask");
        AttrValue xm = nodeDef.getAttrOrThrow("ellipsis_mask");
        AttrValue em = nodeDef.getAttrOrThrow("end_mask");
        AttrValue nm = nodeDef.getAttrOrThrow("new_axis_mask");
        AttrValue sm = nodeDef.getAttrOrThrow("shrink_axis_mask");
        this.addIArgument((int)bm.getI());
        this.addIArgument((int)xm.getI());
        this.addIArgument((int)em.getI());
        this.addIArgument((int)nm.getI());
        this.addIArgument((int)sm.getI());
        INDArray beginArr = TFGraphMapper.getInstance().getNDArrayFromTensor("value", beginNode, graph);
        INDArray endArr = TFGraphMapper.getInstance().getNDArrayFromTensor("value", endNode, graph);
        INDArray stridesArr = TFGraphMapper.getInstance().getNDArrayFromTensor("value", strides, graph);
        if (beginArr != null && endArr != null && stridesArr != null) {
            int e = 0;
            while ((long)e < beginArr.length()) {
                this.addIArgument(beginArr.getInt(e++));
            }
            e = 0;
            while ((long)e < endArr.length()) {
                this.addIArgument(endArr.getInt(e++));
            }
            e = 0;
            while ((long)e < stridesArr.length()) {
                this.addIArgument(stridesArr.getInt(e++));
            }
        }
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping beginMapping = PropertyMapping.builder().tfInputPosition(1).propertyNames(new String[]{"begin"}).build();
        PropertyMapping end = PropertyMapping.builder().tfInputPosition(2).propertyNames(new String[]{"end"}).build();
        PropertyMapping strides = PropertyMapping.builder().tfInputPosition(3).propertyNames(new String[]{"strides"}).build();
        PropertyMapping beginMask = PropertyMapping.builder().tfAttrName("begin_mask").propertyNames(new String[]{"beginMask"}).build();
        PropertyMapping ellipsisMask = PropertyMapping.builder().tfAttrName("ellipsis_mask").propertyNames(new String[]{"ellipsisMask"}).build();
        PropertyMapping endMask = PropertyMapping.builder().tfAttrName("end_mask").propertyNames(new String[]{"endMask"}).build();
        PropertyMapping newAxisMask = PropertyMapping.builder().tfAttrName("new_axis_mask").propertyNames(new String[]{"newAxisMask"}).build();
        PropertyMapping shrinkAxisMask = PropertyMapping.builder().tfAttrName("shrink_axis_mask").propertyNames(new String[]{"shrinkAxisMask"}).build();
        map.put("begin", beginMapping);
        map.put("end", end);
        map.put("strides", strides);
        map.put("beginMask", beginMask);
        map.put("ellipsisMask", ellipsisMask);
        map.put("endMask", endMask);
        map.put("newAxisMask", newAxisMask);
        map.put("shrinkAxisMask", shrinkAxisMask);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        return Collections.singletonList(this.f().stridedSliceBp(this.arg(), i_v.get(0), this.begin, this.end, this.strides, this.beginMask, this.endMask, this.ellipsisMask, this.newAxisMask, this.shrinkAxisMask));
    }
}

