/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.adapter;

import java.util.NoSuchElementException;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;

public class SingletonMultiDataSetIterator
implements MultiDataSetIterator {
    private final MultiDataSet multiDataSet;
    private boolean hasNext = true;
    private boolean preprocessed = false;
    private MultiDataSetPreProcessor preProcessor;

    public SingletonMultiDataSetIterator(MultiDataSet multiDataSet) {
        this.multiDataSet = multiDataSet;
    }

    @Override
    public MultiDataSet next(int num) {
        return this.next();
    }

    @Override
    public void setPreProcessor(MultiDataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    @Override
    public MultiDataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    @Override
    public boolean resetSupported() {
        return true;
    }

    @Override
    public boolean asyncSupported() {
        return false;
    }

    @Override
    public void reset() {
        this.hasNext = true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public MultiDataSet next() {
        if (!this.hasNext) {
            throw new NoSuchElementException("No elements remaining");
        }
        this.hasNext = false;
        if (this.preProcessor != null && !this.preprocessed) {
            this.preProcessor.preProcess(this.multiDataSet);
            this.preprocessed = true;
        }
        return this.multiDataSet;
    }

    @Override
    public void remove() {
    }
}

