/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning.config;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.RmsPropUpdater;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class RmsProp
implements IUpdater {
    public static final double DEFAULT_RMSPROP_LEARNING_RATE = 0.1;
    public static final double DEFAULT_RMSPROP_EPSILON = 1.0E-8;
    public static final double DEFAULT_RMSPROP_RMSDECAY = 0.95;
    private double learningRate;
    private ISchedule learningRateSchedule;
    private double rmsDecay;
    private double epsilon;

    public RmsProp() {
        this(0.1, null, 0.95, 1.0E-8);
    }

    public RmsProp(double learningRate) {
        this(learningRate, null, 0.95, 1.0E-8);
    }

    public RmsProp(ISchedule learningRateSchedule) {
        this(Double.NaN, learningRateSchedule, 0.95, 1.0E-8);
    }

    public RmsProp(double learningRate, double rmsDecay, double epsilon) {
        this(learningRate, null, rmsDecay, epsilon);
    }

    private RmsProp(@JsonProperty(value="learningRate") double learningRate, @JsonProperty(value="learningRateSchedule") ISchedule learningRateSchedule, @JsonProperty(value="rmsDecay") double rmsDecay, @JsonProperty(value="epsilon") double epsilon) {
        this.learningRate = learningRate;
        this.learningRateSchedule = learningRateSchedule;
        this.rmsDecay = rmsDecay;
        this.epsilon = epsilon;
    }

    @Override
    public long stateSize(long numParams) {
        return numParams;
    }

    @Override
    public GradientUpdater instantiate(INDArray viewArray, boolean initializeViewArray) {
        RmsPropUpdater u = new RmsPropUpdater(this);
        u.setStateViewArray(viewArray, viewArray.shape(), viewArray.ordering(), initializeViewArray);
        return u;
    }

    @Override
    public RmsProp clone() {
        return new RmsProp(this.learningRate, this.learningRateSchedule, this.rmsDecay, this.epsilon);
    }

    @Override
    public double getLearningRate(int iteration, int epoch) {
        if (this.learningRateSchedule != null) {
            return this.learningRateSchedule.valueAt(iteration, epoch);
        }
        return this.learningRate;
    }

    @Override
    public boolean hasLearningRate() {
        return true;
    }

    @Override
    public void setLrAndSchedule(double lr, ISchedule lrSchedule) {
        this.learningRate = lr;
        this.learningRateSchedule = lrSchedule;
    }

    private static double $default$learningRate() {
        return 0.1;
    }

    private static double $default$rmsDecay() {
        return 0.95;
    }

    private static double $default$epsilon() {
        return 1.0E-8;
    }

    public static Builder builder() {
        return new Builder();
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public ISchedule getLearningRateSchedule() {
        return this.learningRateSchedule;
    }

    public double getRmsDecay() {
        return this.rmsDecay;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setLearningRateSchedule(ISchedule learningRateSchedule) {
        this.learningRateSchedule = learningRateSchedule;
    }

    public void setRmsDecay(double rmsDecay) {
        this.rmsDecay = rmsDecay;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RmsProp)) {
            return false;
        }
        RmsProp other = (RmsProp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        ISchedule this$learningRateSchedule = this.getLearningRateSchedule();
        ISchedule other$learningRateSchedule = other.getLearningRateSchedule();
        if (this$learningRateSchedule == null ? other$learningRateSchedule != null : !this$learningRateSchedule.equals(other$learningRateSchedule)) {
            return false;
        }
        if (Double.compare(this.getRmsDecay(), other.getRmsDecay()) != 0) {
            return false;
        }
        return Double.compare(this.getEpsilon(), other.getEpsilon()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof RmsProp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        ISchedule $learningRateSchedule = this.getLearningRateSchedule();
        result = result * 59 + ($learningRateSchedule == null ? 43 : $learningRateSchedule.hashCode());
        long $rmsDecay = Double.doubleToLongBits(this.getRmsDecay());
        result = result * 59 + (int)($rmsDecay >>> 32 ^ $rmsDecay);
        long $epsilon = Double.doubleToLongBits(this.getEpsilon());
        result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
        return result;
    }

    public String toString() {
        return "RmsProp(learningRate=" + this.getLearningRate() + ", learningRateSchedule=" + this.getLearningRateSchedule() + ", rmsDecay=" + this.getRmsDecay() + ", epsilon=" + this.getEpsilon() + ")";
    }

    public static class Builder {
        private boolean learningRate$set;
        private double learningRate;
        private ISchedule learningRateSchedule;
        private boolean rmsDecay$set;
        private double rmsDecay;
        private boolean epsilon$set;
        private double epsilon;

        public Builder learningRate(double learningRate) {
            this.learningRate = learningRate;
            this.learningRate$set = true;
            return this;
        }

        public Builder learningRateSchedule(ISchedule learningRateSchedule) {
            this.learningRateSchedule = learningRateSchedule;
            return this;
        }

        public Builder rmsDecay(double rmsDecay) {
            this.rmsDecay = rmsDecay;
            this.rmsDecay$set = true;
            return this;
        }

        public Builder epsilon(double epsilon) {
            this.epsilon = epsilon;
            this.epsilon$set = true;
            return this;
        }

        public RmsProp build() {
            double learningRate = this.learningRate;
            if (!this.learningRate$set) {
                learningRate = RmsProp.$default$learningRate();
            }
            double rmsDecay = this.rmsDecay;
            if (!this.rmsDecay$set) {
                rmsDecay = RmsProp.$default$rmsDecay();
            }
            double epsilon = this.epsilon;
            if (!this.epsilon$set) {
                epsilon = RmsProp.$default$epsilon();
            }
            return new RmsProp(learningRate, this.learningRateSchedule, rmsDecay, epsilon);
        }

        public String toString() {
            return "RmsProp.Builder(learningRate=" + this.learningRate + ", learningRateSchedule=" + this.learningRateSchedule + ", rmsDecay=" + this.rmsDecay + ", epsilon=" + this.epsilon + ")";
        }
    }
}

