/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class SigmoidUniformInitScheme
extends BaseWeightInitScheme {
    private double fanIn;
    private double fanOut;

    public SigmoidUniformInitScheme(char order, double fanIn, double fanOut) {
        super(order);
        this.fanIn = fanIn;
        this.fanOut = fanOut;
    }

    @Override
    public INDArray doCreate(long[] shape, INDArray paramsView) {
        double r = 4.0 * Math.sqrt(6.0 / (this.fanIn + this.fanOut));
        return Nd4j.rand(shape, Nd4j.getDistributions().createUniform(-r, r));
    }

    @Override
    public WeightInit type() {
        return WeightInit.SIGMOID_UNIFORM;
    }

    public static SigmoidUniformInitSchemeBuilder builder() {
        return new SigmoidUniformInitSchemeBuilder();
    }

    public static class SigmoidUniformInitSchemeBuilder {
        private char order;
        private double fanIn;
        private double fanOut;

        SigmoidUniformInitSchemeBuilder() {
        }

        public SigmoidUniformInitSchemeBuilder order(char order) {
            this.order = order;
            return this;
        }

        public SigmoidUniformInitSchemeBuilder fanIn(double fanIn) {
            this.fanIn = fanIn;
            return this;
        }

        public SigmoidUniformInitSchemeBuilder fanOut(double fanOut) {
            this.fanOut = fanOut;
            return this;
        }

        public SigmoidUniformInitScheme build() {
            return new SigmoidUniformInitScheme(this.order, this.fanIn, this.fanOut);
        }

        public String toString() {
            return "SigmoidUniformInitScheme.SigmoidUniformInitSchemeBuilder(order=" + this.order + ", fanIn=" + this.fanIn + ", fanOut=" + this.fanOut + ")";
        }
    }
}

