/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Bfloat16Indexer;
import org.bytedeco.javacpp.indexer.BooleanIndexer;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.HalfIndexer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UIntIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;
import org.nd4j.common.primitives.AtomicBoolean;
import org.nd4j.common.primitives.AtomicDouble;
import org.nd4j.common.primitives.Triple;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDataBuffer
implements DataBuffer {
    private static final Logger log = LoggerFactory.getLogger(BaseDataBuffer.class);
    public static String TO_STRING_MAX_ELEMENTS = "org.nd4j.databuffer.tostring.maxelements";
    private static int TO_STRING_MAX;
    protected DataType type;
    protected long length;
    protected long underlyingLength;
    protected long offset;
    protected byte elementSize;
    protected transient DataBuffer wrappedDataBuffer;
    protected transient long workspaceGenerationId = 0L;
    protected DataBuffer.AllocationMode allocationMode;
    protected transient Indexer indexer = null;
    protected transient Pointer pointer = null;
    protected transient boolean attached = false;
    protected transient MemoryWorkspace parentWorkspace;
    protected transient DataBuffer originalBuffer;
    protected transient long originalOffset = 0L;
    protected transient boolean constant = false;
    protected transient boolean released = false;
    protected transient AtomicBoolean referenced = new AtomicBoolean(false);

    public BaseDataBuffer() {
    }

    protected abstract void initTypeAndSize();

    @Override
    public int getElementSize() {
        return this.elementSize;
    }

    @Override
    public long getGenerationId() {
        if (this.parentWorkspace != null) {
            return this.workspaceGenerationId;
        }
        if (this.wrappedDataBuffer != null && this.wrappedDataBuffer.isAttached()) {
            return this.wrappedDataBuffer.getGenerationId();
        }
        if (this.originalBuffer != null && this.originalBuffer.isAttached()) {
            return this.originalBuffer.getGenerationId();
        }
        return this.workspaceGenerationId;
    }

    public BaseDataBuffer(Pointer pointer, Indexer indexer, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("Length must be >= 0");
        }
        this.initTypeAndSize();
        this.length = length;
        this.allocationMode = DataBuffer.AllocationMode.MIXED_DATA_TYPES;
        this.underlyingLength = length;
        this.wrappedDataBuffer = this;
        if (length > 0L) {
            this.pointer = pointer;
            this.setIndexer(indexer);
        }
    }

    protected void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    protected void pickReferent(BaseDataBuffer referent) {
        this.referenced.compareAndSet(false, true);
    }

    protected BaseDataBuffer(DataBuffer underlyingBuffer, long length, long offset) {
        if (length < 0L) {
            throw new IllegalArgumentException("Length must be >= 0");
        }
        if (length == 0L) {
            length = 1L;
        }
        this.initTypeAndSize();
        this.length = length;
        this.offset = offset;
        this.allocationMode = underlyingBuffer.allocationMode();
        this.elementSize = (byte)underlyingBuffer.getElementSize();
        this.underlyingLength = underlyingBuffer.underlyingLength();
        this.wrappedDataBuffer = underlyingBuffer;
        if (!underlyingBuffer.isConstant()) {
            ((BaseDataBuffer)underlyingBuffer).pickReferent(this);
        }
        if (underlyingBuffer.originalDataBuffer() == null) {
            this.originalBuffer = underlyingBuffer;
            this.originalOffset = offset;
        } else {
            this.originalBuffer = underlyingBuffer.originalDataBuffer();
            this.originalOffset = offset;
        }
        this.pointer = underlyingBuffer.pointer();
        this.setIndexer(underlyingBuffer.indexer());
    }

    @Override
    public DataBuffer originalDataBuffer() {
        return this.originalBuffer;
    }

    protected void setNioBuffer() {
        if ((long)this.elementSize * this.length >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to create buffer of length " + this.length);
        }
    }

    @Override
    public Indexer indexer() {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        return this.indexer;
    }

    @Override
    public Pointer pointer() {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        if (this.underlyingDataBuffer() != null && this.underlyingDataBuffer() != this) {
            if (this.underlyingDataBuffer().wasClosed()) {
                throw new IllegalStateException("You can't use DataBuffer once it was released");
            }
            return this.underlyingDataBuffer().pointer();
        }
        if (this.underlyingDataBuffer() != null && ((BaseDataBuffer)this.underlyingDataBuffer()).released) {
            throw new IllegalStateException("Underlying buffer was released via close() call");
        }
        if (this.released) {
            throw new IllegalStateException("This buffer was already released via close() call");
        }
        return this.pointer;
    }

    @Override
    public DataBuffer underlyingDataBuffer() {
        return this.wrappedDataBuffer;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public DataBuffer.AllocationMode allocationMode() {
        return this.allocationMode;
    }

    @Override
    @Deprecated
    public void persist() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean isPersist() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void unPersist() {
        throw new UnsupportedOperationException();
    }

    protected void fillPointerWithZero() {
        Pointer.memset((Pointer)this.pointer(), (int)0, (long)((long)this.getElementSize() * this.length()));
    }

    @Override
    public void copyAtStride(DataBuffer buf, long n, long stride, long yStride, long offset, long yOffset) {
        if (this.dataType() == DataType.FLOAT) {
            int i = 0;
            while ((long)i < n) {
                this.put(offset + (long)i * stride, buf.getFloat(yOffset + (long)i * yStride));
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < n) {
                this.put(offset + (long)i * stride, buf.getDouble(yOffset + (long)i * yStride));
                ++i;
            }
        }
    }

    @Override
    @Deprecated
    public void removeReferencing(String id) {
    }

    @Override
    @Deprecated
    public Collection<String> references() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract Pointer addressPointer();

    @Override
    public long address() {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        return this.pointer().address();
    }

    @Override
    @Deprecated
    public void addReferencing(String id) {
    }

    @Override
    public void assign(long[] indices, float[] data, boolean contiguous, long inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if ((long)indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        for (int i = 0; i < indices.length; ++i) {
            this.put(indices[i], data[i]);
        }
    }

    @Override
    public void setData(int[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.put((long)i, data[i]);
        }
    }

    @Override
    public void setData(float[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.put((long)i, data[i]);
        }
    }

    @Override
    public void setData(double[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.put((long)i, data[i]);
        }
    }

    @Override
    public void setData(long[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.put((long)i, data[i]);
        }
    }

    @Override
    public void setData(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.put((long)i, data[i]);
        }
    }

    @Override
    public void setData(short[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.put((long)i, data[i]);
        }
    }

    @Override
    public void setData(boolean[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.put((long)i, data[i]);
        }
    }

    @Override
    public void assign(long[] indices, double[] data, boolean contiguous, long inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if ((long)indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        int i = 0;
        while (i < indices.length) {
            this.put(indices[i], data[i]);
            i = (int)((long)i + inc);
        }
    }

    @Override
    public void assign(DataBuffer data) {
        if (data.length() != this.length()) {
            throw new IllegalArgumentException("Unable to assign buffer of length " + data.length() + " to this buffer of length " + this.length());
        }
        int i = 0;
        while ((long)i < data.length()) {
            this.put((long)i, data.getDouble(i));
            ++i;
        }
    }

    @Override
    public void assign(long[] indices, float[] data, boolean contiguous) {
        this.assign(indices, data, contiguous, 1L);
    }

    @Override
    public void assign(long[] indices, double[] data, boolean contiguous) {
        this.assign(indices, data, contiguous, 1L);
    }

    @Override
    public long underlyingLength() {
        return this.underlyingLength;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void assign(Number value) {
        this.assign(value, 0L);
    }

    @Override
    public double[] getDoublesAt(long offset, long inc, int length) {
        if (offset + (long)length > this.length()) {
            length = (int)((long)length - offset);
        }
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getDouble((long)i * inc + offset);
        }
        return ret;
    }

    @Override
    public double[] getDoublesAt(long offset, int length) {
        return this.getDoublesAt(offset, 1L, length);
    }

    @Override
    public float[] getFloatsAt(long offset, int length) {
        return this.getFloatsAt(offset, 1L, length);
    }

    @Override
    public float[] getFloatsAt(long offset, long inc, int length) {
        if (offset + (long)length > this.length()) {
            length = (int)((long)length - offset);
        }
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getFloat((long)i * inc + offset);
        }
        return ret;
    }

    @Override
    public long[] getLongsAt(long offset, int length) {
        return this.getLongsAt(offset, 1L, length);
    }

    @Override
    public long[] getLongsAt(long offset, long inc, int length) {
        if (offset + (long)length > this.length()) {
            length = (int)((long)length - offset);
        }
        long[] ret = new long[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getLong((long)i * inc + offset);
        }
        return ret;
    }

    @Override
    public int[] getIntsAt(long offset, int length) {
        return this.getIntsAt(offset, 1L, length);
    }

    @Override
    public int[] getIntsAt(long offset, long inc, int length) {
        if (offset + (long)length > this.length()) {
            length = (int)((long)length - offset);
        }
        int[] ret = new int[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = this.getInt((long)i * inc + offset);
        }
        return ret;
    }

    @Override
    public DataBuffer dup() {
        DataBuffer ret = this.create(this.length);
        int i = 0;
        while ((long)i < ret.length()) {
            ret.put((long)i, this.getDouble(i));
            ++i;
        }
        return ret;
    }

    protected abstract DataBuffer create(long var1);

    public abstract DataBuffer create(double[] var1);

    public abstract DataBuffer create(float[] var1);

    public abstract DataBuffer create(int[] var1);

    @Override
    public void assign(long[] offsets, long[] strides, DataBuffer ... buffers) {
        this.assign(offsets, strides, this.length(), buffers);
    }

    @Override
    public byte[] asBytes() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        DataType dataType = this.dataType();
        switch (dataType) {
            case DOUBLE: {
                try {
                    int i = 0;
                    while ((long)i < this.length()) {
                        dos.writeDouble(this.getDouble(i));
                        ++i;
                    }
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case FLOAT: {
                try {
                    int i = 0;
                    while ((long)i < this.length()) {
                        dos.writeFloat(this.getFloat(i));
                        ++i;
                    }
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case HALF: {
                try {
                    int i = 0;
                    while ((long)i < this.length()) {
                        dos.writeShort(HalfIndexer.fromFloat((float)this.getFloat(i)));
                        ++i;
                    }
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case BOOL: {
                try {
                    int i = 0;
                    while ((long)i < this.length()) {
                        dos.writeByte(this.getInt(i) == 0 ? 0 : 1);
                        ++i;
                    }
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case BYTE: {
                try {
                    int i = 0;
                    while ((long)i < this.length()) {
                        dos.writeByte((byte)this.getShort(i));
                        ++i;
                    }
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case UBYTE: {
                try {
                    UByteIndexer u = (UByteIndexer)this.indexer;
                    int i = 0;
                    while ((long)i < this.length()) {
                        dos.writeByte(u.get((long)i));
                        ++i;
                    }
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case SHORT: {
                try {
                    int i = 0;
                    while ((long)i < this.length()) {
                        dos.writeShort(this.getShort(i));
                        ++i;
                    }
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case INT: {
                try {
                    int i = 0;
                    while ((long)i < this.length()) {
                        dos.writeInt(this.getInt(i));
                        ++i;
                    }
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case LONG: {
                try {
                    int i = 0;
                    while ((long)i < this.length()) {
                        dos.writeLong(this.getLong(i));
                        ++i;
                    }
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case BFLOAT16: 
            case UINT16: {
                byte[] temp = new byte[(int)(2L * this.length)];
                this.asNio().get(temp);
                try {
                    if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
                        for (int i = 0; i < temp.length / 2; ++i) {
                            dos.write(temp[2 * i + 1]);
                            dos.write(temp[2 * i]);
                        }
                        break;
                    }
                    dos.write(temp);
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case UINT64: {
                byte[] temp2 = new byte[(int)(8L * this.length)];
                this.asNio().get(temp2);
                try {
                    if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
                        for (int i = 0; i < temp2.length / 8; ++i) {
                            for (int j = 0; j < 8; ++j) {
                                dos.write(temp2[8 * i + (7 - j)]);
                            }
                        }
                        break;
                    }
                    dos.write(temp2);
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case UINT32: {
                byte[] temp3 = new byte[(int)(4L * this.length)];
                this.asNio().get(temp3);
                try {
                    if (ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
                        for (int i = 0; i < temp3.length / 4; ++i) {
                            for (int j = 0; j < 4; ++j) {
                                dos.write(temp3[4 * i + (3 - j)]);
                            }
                        }
                        break;
                    }
                    dos.write(temp3);
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            case UTF8: {
                byte[] temp4 = new byte[(int)this.length];
                this.asNio().get(temp4);
                try {
                    dos.write(temp4);
                    break;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new UnsupportedOperationException("Unknown data type: [" + (Object)((Object)dataType) + "]");
            }
        }
        return bos.toByteArray();
    }

    @Override
    public float[] asFloat() {
        if (this.length >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to create array of length " + this.length);
        }
        float[] ret = new float[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            ret[i] = this.getFloatUnsynced(i);
            ++i;
        }
        return ret;
    }

    @Override
    public double[] asDouble() {
        if (this.length >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to create array of length " + this.length);
        }
        double[] ret = new double[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            ret[i] = this.getDoubleUnsynced(i);
            ++i;
        }
        return ret;
    }

    @Override
    public int[] asInt() {
        if (this.length >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to create array of length " + this.length);
        }
        int[] ret = new int[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            ret[i] = this.getIntUnsynced(i);
            ++i;
        }
        return ret;
    }

    @Override
    public long[] asLong() {
        if (this.length >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unable to create array of length " + this.length);
        }
        long[] ret = new long[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            ret[i] = this.getLongUnsynced(i);
            ++i;
        }
        return ret;
    }

    @Override
    public double getDouble(long i) {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        if (this.indexer == null) {
            throw new IllegalStateException("Indexer must never be null");
        }
        switch (this.dataType()) {
            case FLOAT: {
                return ((FloatIndexer)this.indexer).get(i);
            }
            case UINT32: {
                return ((UIntIndexer)this.indexer).get(i);
            }
            case INT: {
                return ((IntIndexer)this.indexer).get(i);
            }
            case BFLOAT16: {
                return ((Bfloat16Indexer)this.indexer).get(i);
            }
            case HALF: {
                return ((HalfIndexer)this.indexer).get(i);
            }
            case UINT16: {
                return ((UShortIndexer)this.indexer).get(i);
            }
            case SHORT: {
                return ((ShortIndexer)this.indexer).get(i);
            }
            case LONG: 
            case UINT64: {
                return ((LongIndexer)this.indexer).get(i);
            }
            case BOOL: {
                return ((BooleanIndexer)this.indexer).get(i) ? 1.0 : 0.0;
            }
            case DOUBLE: {
                return ((DoubleIndexer)this.indexer).get(i);
            }
            case BYTE: {
                return ((ByteIndexer)this.indexer).get(i);
            }
            case UBYTE: {
                return ((UByteIndexer)this.indexer).get(i);
            }
        }
        throw new UnsupportedOperationException("Cannot get double value from buffer of type " + (Object)((Object)this.dataType()));
    }

    @Override
    public long getLong(long i) {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        switch (this.dataType()) {
            case FLOAT: {
                return (long)((FloatIndexer)this.indexer).get(i);
            }
            case DOUBLE: {
                return (long)((DoubleIndexer)this.indexer).get(i);
            }
            case BFLOAT16: {
                return (long)((Bfloat16Indexer)this.indexer).get(i);
            }
            case HALF: {
                return (long)((HalfIndexer)this.indexer).get(i);
            }
            case LONG: 
            case UINT64: {
                return ((LongIndexer)this.indexer).get(i);
            }
            case UINT32: {
                return ((UIntIndexer)this.indexer).get(i);
            }
            case INT: {
                return ((IntIndexer)this.indexer).get(i);
            }
            case UINT16: {
                return ((UShortIndexer)this.indexer).get(i);
            }
            case SHORT: {
                return ((ShortIndexer)this.indexer).get(i);
            }
            case BYTE: {
                return ((ByteIndexer)this.indexer).get(i);
            }
            case UBYTE: {
                return ((UByteIndexer)this.indexer).get(i);
            }
            case BOOL: {
                return ((BooleanIndexer)this.indexer).get(i) ? 1L : 0L;
            }
        }
        throw new UnsupportedOperationException("Cannot get long value from buffer of type " + (Object)((Object)this.dataType()));
    }

    protected short getShort(long i) {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        switch (this.dataType()) {
            case DOUBLE: {
                return (short)((DoubleIndexer)this.indexer).get(i);
            }
            case BFLOAT16: {
                return (short)((Bfloat16Indexer)this.indexer).get(i);
            }
            case HALF: {
                return (short)((HalfIndexer)this.indexer).get(i);
            }
            case BOOL: {
                return (short)(((BooleanIndexer)this.indexer).get(i) ? 1 : 0);
            }
            case UINT32: {
                return (short)((UIntIndexer)this.indexer).get(i);
            }
            case INT: {
                return (short)((IntIndexer)this.indexer).get(i);
            }
            case SHORT: 
            case UINT16: {
                return ((ShortIndexer)this.indexer).get(i);
            }
            case BYTE: {
                return ((ByteIndexer)this.indexer).get(i);
            }
            case LONG: 
            case UINT64: {
                return (short)((LongIndexer)this.indexer).get(i);
            }
            case FLOAT: {
                return (short)((FloatIndexer)this.indexer).get(i);
            }
        }
        throw new UnsupportedOperationException("Cannot get short value from buffer of type " + (Object)((Object)this.dataType()));
    }

    public static short fromFloat(float v) {
        return ArrayUtil.fromFloat((float)v);
    }

    @Override
    public float getFloat(long i) {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        switch (this.dataType()) {
            case DOUBLE: {
                return (float)((DoubleIndexer)this.indexer).get(i);
            }
            case BOOL: {
                return ((BooleanIndexer)this.indexer).get(i) ? 1.0f : 0.0f;
            }
            case UINT32: {
                return ((UIntIndexer)this.indexer).get(i);
            }
            case INT: {
                return ((IntIndexer)this.indexer).get(i);
            }
            case UINT16: {
                return ((UShortIndexer)this.indexer).get(i);
            }
            case SHORT: {
                return ((ShortIndexer)this.indexer).get(i);
            }
            case BFLOAT16: {
                return ((Bfloat16Indexer)this.indexer).get(i);
            }
            case HALF: {
                return ((HalfIndexer)this.indexer).get(i);
            }
            case UBYTE: {
                return ((UByteIndexer)this.indexer).get(i);
            }
            case BYTE: {
                return ((ByteIndexer)this.indexer).get(i);
            }
            case LONG: 
            case UINT64: {
                return ((LongIndexer)this.indexer).get(i);
            }
            case FLOAT: {
                return ((FloatIndexer)this.indexer).get(i);
            }
        }
        throw new UnsupportedOperationException("Cannot get float value from buffer of type " + (Object)((Object)this.dataType()));
    }

    @Override
    public int getInt(long i) {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        switch (this.dataType()) {
            case DOUBLE: {
                return (int)((DoubleIndexer)this.indexer).get(i);
            }
            case BOOL: {
                return ((BooleanIndexer)this.indexer).get(i) ? 1 : 0;
            }
            case UINT32: {
                return (int)((UIntIndexer)this.indexer).get(i);
            }
            case INT: {
                return ((IntIndexer)this.indexer).get(i);
            }
            case BFLOAT16: {
                return (int)((Bfloat16Indexer)this.indexer).get(i);
            }
            case HALF: {
                return (int)((HalfIndexer)this.indexer).get(i);
            }
            case UINT16: {
                return ((UShortIndexer)this.indexer).get(i);
            }
            case SHORT: {
                return ((ShortIndexer)this.indexer).get(i);
            }
            case UBYTE: {
                return ((UByteIndexer)this.indexer).get(i);
            }
            case BYTE: {
                return ((ByteIndexer)this.indexer).get(i);
            }
            case LONG: 
            case UINT64: {
                return (int)((LongIndexer)this.indexer).get(i);
            }
            case FLOAT: {
                return (int)((FloatIndexer)this.indexer).get(i);
            }
        }
        throw new UnsupportedOperationException("Cannot get integer value from buffer of type " + (Object)((Object)this.dataType()));
    }

    @Override
    public Number getNumber(long i) {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        if (this.dataType() == DataType.DOUBLE) {
            return this.getDouble(i);
        }
        if (this.dataType() == DataType.INT) {
            return this.getInt(i);
        }
        if (this.dataType() == DataType.LONG) {
            return this.getLong(i);
        }
        return Float.valueOf(this.getFloat(i));
    }

    public abstract void pointerIndexerByCurrentType(DataType var1);

    public void putByDestinationType(long i, Number element, DataType globalType) {
        if (globalType == DataType.INT || this.type == DataType.INT || globalType == DataType.UINT16 || globalType == DataType.UBYTE || globalType == DataType.SHORT || globalType == DataType.BYTE || globalType == DataType.BOOL) {
            int anElement = element.intValue();
            this.put(i, anElement);
        } else if (globalType == DataType.LONG || this.type == DataType.LONG || globalType == DataType.UINT32 || globalType == DataType.UINT64) {
            long anElement = element.longValue();
            this.put(i, anElement);
        } else if (globalType == DataType.FLOAT || globalType == DataType.HALF || globalType == DataType.BFLOAT16) {
            float anElement = element.floatValue();
            this.put(i, anElement);
        } else if (globalType == DataType.DOUBLE) {
            double anElement = element.doubleValue();
            this.put(i, anElement);
        } else {
            throw new IllegalStateException("Unknown type: " + (Object)((Object)globalType));
        }
    }

    @Override
    public void put(long i, float element) {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        switch (this.dataType()) {
            case BOOL: {
                ((BooleanIndexer)this.indexer).put(i, (double)element != 0.0);
                break;
            }
            case BYTE: {
                ((ByteIndexer)this.indexer).put(i, (byte)element);
                break;
            }
            case UBYTE: {
                ((UByteIndexer)this.indexer).put(i, (int)element);
                break;
            }
            case UINT16: {
                ((UShortIndexer)this.indexer).put(i, (int)element);
                break;
            }
            case SHORT: {
                ((ShortIndexer)this.indexer).put(i, (short)element);
                break;
            }
            case UINT32: {
                ((UIntIndexer)this.indexer).put(i, (long)element);
                break;
            }
            case INT: {
                ((IntIndexer)this.indexer).put(i, (int)element);
                break;
            }
            case LONG: 
            case UINT64: {
                ((LongIndexer)this.indexer).put(i, (long)element);
                break;
            }
            case BFLOAT16: {
                ((Bfloat16Indexer)this.indexer).put(i, element);
                break;
            }
            case HALF: {
                ((HalfIndexer)this.indexer).put(i, element);
                break;
            }
            case FLOAT: {
                ((FloatIndexer)this.indexer).put(i, element);
                break;
            }
            case DOUBLE: {
                ((DoubleIndexer)this.indexer).put(i, (double)element);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported type: " + (Object)((Object)this.dataType()));
            }
        }
    }

    @Override
    public void put(long i, double element) {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        switch (this.dataType()) {
            case BOOL: {
                ((BooleanIndexer)this.indexer).put(i, element > 0.0);
                break;
            }
            case BYTE: {
                ((ByteIndexer)this.indexer).put(i, (byte)element);
                break;
            }
            case UBYTE: {
                ((UByteIndexer)this.indexer).put(i, (int)((short)element));
                break;
            }
            case UINT16: {
                ((UShortIndexer)this.indexer).put(i, (int)element);
                break;
            }
            case SHORT: {
                ((ShortIndexer)this.indexer).put(i, (short)element);
                break;
            }
            case UINT32: {
                ((UIntIndexer)this.indexer).put(i, (long)element);
                break;
            }
            case INT: {
                ((IntIndexer)this.indexer).put(i, (int)element);
                break;
            }
            case LONG: 
            case UINT64: {
                ((LongIndexer)this.indexer).put(i, (long)element);
                break;
            }
            case BFLOAT16: {
                ((Bfloat16Indexer)this.indexer).put(i, (float)element);
                break;
            }
            case HALF: {
                ((HalfIndexer)this.indexer).put(i, (float)element);
                break;
            }
            case FLOAT: {
                ((FloatIndexer)this.indexer).put(i, (float)element);
                break;
            }
            case DOUBLE: {
                ((DoubleIndexer)this.indexer).put(i, element);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)this.dataType()));
            }
        }
    }

    @Override
    public void put(long i, int element) {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        switch (this.dataType()) {
            case BOOL: {
                ((BooleanIndexer)this.indexer).put(i, element != 0);
                break;
            }
            case BYTE: {
                ((ByteIndexer)this.indexer).put(i, (byte)element);
                break;
            }
            case UBYTE: {
                ((UByteIndexer)this.indexer).put(i, element);
                break;
            }
            case UINT16: {
                ((UShortIndexer)this.indexer).put(i, element);
                break;
            }
            case SHORT: {
                ((ShortIndexer)this.indexer).put(i, (short)element);
                break;
            }
            case UINT32: {
                ((UIntIndexer)this.indexer).put(i, (long)element);
                break;
            }
            case INT: {
                ((IntIndexer)this.indexer).put(i, element);
                break;
            }
            case LONG: 
            case UINT64: {
                ((LongIndexer)this.indexer).put(i, (long)element);
                break;
            }
            case BFLOAT16: {
                ((Bfloat16Indexer)this.indexer).put(i, (float)element);
                break;
            }
            case HALF: {
                ((HalfIndexer)this.indexer).put(i, (float)element);
                break;
            }
            case FLOAT: {
                ((FloatIndexer)this.indexer).put(i, (float)element);
                break;
            }
            case DOUBLE: {
                ((DoubleIndexer)this.indexer).put(i, (double)element);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)this.dataType()));
            }
        }
    }

    @Override
    public void put(long i, boolean element) {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        switch (this.dataType()) {
            case BOOL: {
                ((BooleanIndexer)this.indexer).put(i, element);
                break;
            }
            case BYTE: {
                ((ByteIndexer)this.indexer).put(i, element ? (byte)1 : 0);
                break;
            }
            case UBYTE: {
                ((UByteIndexer)this.indexer).put(i, element ? 1 : 0);
                break;
            }
            case UINT16: {
                ((UShortIndexer)this.indexer).put(i, element ? 1 : 0);
                break;
            }
            case SHORT: {
                ((ShortIndexer)this.indexer).put(i, element ? (short)1 : 0);
                break;
            }
            case UINT32: {
                ((UIntIndexer)this.indexer).put(i, element ? 1L : 0L);
                break;
            }
            case INT: {
                ((IntIndexer)this.indexer).put(i, element ? 1 : 0);
                break;
            }
            case LONG: 
            case UINT64: {
                ((LongIndexer)this.indexer).put(i, element ? 1L : 0L);
                break;
            }
            case BFLOAT16: {
                ((Bfloat16Indexer)this.indexer).put(i, element ? 1.0f : 0.0f);
                break;
            }
            case HALF: {
                ((HalfIndexer)this.indexer).put(i, element ? 1.0f : 0.0f);
                break;
            }
            case FLOAT: {
                ((FloatIndexer)this.indexer).put(i, element ? 1.0f : 0.0f);
                break;
            }
            case DOUBLE: {
                ((DoubleIndexer)this.indexer).put(i, element ? 1.0 : 0.0);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)this.dataType()));
            }
        }
    }

    @Override
    public void put(long i, long element) {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        switch (this.dataType()) {
            case BOOL: {
                ((BooleanIndexer)this.indexer).put(i, element != 0L);
                break;
            }
            case BYTE: {
                ((ByteIndexer)this.indexer).put(i, (byte)element);
                break;
            }
            case UBYTE: {
                ((UByteIndexer)this.indexer).put(i, (int)((short)element));
                break;
            }
            case UINT16: {
                ((UShortIndexer)this.indexer).put(i, (int)element);
                break;
            }
            case SHORT: {
                ((ShortIndexer)this.indexer).put(i, (short)element);
                break;
            }
            case UINT32: {
                ((UIntIndexer)this.indexer).put(i, element);
                break;
            }
            case INT: {
                ((IntIndexer)this.indexer).put(i, (int)element);
                break;
            }
            case LONG: 
            case UINT64: {
                ((LongIndexer)this.indexer).put(i, element);
                break;
            }
            case BFLOAT16: {
                ((Bfloat16Indexer)this.indexer).put(i, (float)element);
                break;
            }
            case HALF: {
                ((HalfIndexer)this.indexer).put(i, (float)element);
                break;
            }
            case FLOAT: {
                ((FloatIndexer)this.indexer).put(i, (float)element);
                break;
            }
            case DOUBLE: {
                ((DoubleIndexer)this.indexer).put(i, (double)element);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)this.dataType()));
            }
        }
    }

    @Override
    @Deprecated
    public boolean dirty() {
        return false;
    }

    @Override
    public boolean sameUnderlyingData(DataBuffer buffer) {
        return this.pointer() == buffer.pointer();
    }

    protected ByteBuffer wrappedBuffer() {
        return this.pointer().asByteBuffer();
    }

    @Override
    public IntBuffer asNioInt() {
        if (this.offset() >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Index out of bounds " + this.offset());
        }
        if (this.offset() == 0L) {
            return this.wrappedBuffer().asIntBuffer();
        }
        return (IntBuffer)this.wrappedBuffer().asIntBuffer().position((int)this.offset());
    }

    @Override
    public LongBuffer asNioLong() {
        if (this.offset() >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Index out of bounds " + this.offset());
        }
        if (this.offset() == 0L) {
            return this.wrappedBuffer().asLongBuffer();
        }
        return (LongBuffer)this.wrappedBuffer().asLongBuffer().position((int)this.offset());
    }

    @Override
    public DoubleBuffer asNioDouble() {
        if (this.offset() >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Index out of bounds " + this.offset());
        }
        if (this.offset() == 0L) {
            return this.wrappedBuffer().asDoubleBuffer();
        }
        return (DoubleBuffer)this.wrappedBuffer().asDoubleBuffer().position((int)this.offset());
    }

    @Override
    public FloatBuffer asNioFloat() {
        if (this.offset() >= Integer.MAX_VALUE) {
            throw new IllegalStateException("Index out of bounds " + this.offset());
        }
        if (this.offset() == 0L) {
            return this.wrappedBuffer().asFloatBuffer();
        }
        return (FloatBuffer)this.wrappedBuffer().asFloatBuffer().position((int)this.offset());
    }

    @Override
    public ByteBuffer asNio() {
        return this.wrappedBuffer();
    }

    @Override
    public void assign(Number value, long offset) {
        for (long i = offset; i < this.length(); ++i) {
            this.put(i, value.doubleValue());
        }
    }

    @Override
    public void write(OutputStream dos) {
        if (dos instanceof DataOutputStream) {
            try {
                this.write((DataOutputStream)dos);
            }
            catch (IOException e) {
                throw new IllegalStateException("IO Exception writing buffer", e);
            }
        }
        DataOutputStream dos2 = new DataOutputStream(dos);
        try {
            this.write(dos2);
        }
        catch (IOException e) {
            throw new IllegalStateException("IO Exception writing buffer", e);
        }
    }

    @Override
    public void read(InputStream is, DataBuffer.AllocationMode allocationMode, long length, DataType dataType) {
        if (is instanceof DataInputStream) {
            this.read((DataInputStream)is, allocationMode, length, dataType);
        } else {
            DataInputStream dis2 = new DataInputStream(is);
            this.read(dis2, allocationMode, length, dataType);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void assign(long[] offsets, long[] strides, long n, DataBuffer ... buffers) {
        if (offsets.length != strides.length || strides.length != buffers.length) {
            throw new IllegalArgumentException("Unable to assign buffers, please specify equal lengths strides, offsets, and buffers");
        }
        int count = 0;
        for (int i = 0; i < buffers.length; ++i) {
            for (long j = offsets[i]; j < buffers[i].length(); j += strides[i]) {
                this.put((long)count++, buffers[i].getDouble(j));
            }
        }
        if ((long)count != n) {
            throw new IllegalArgumentException("Strides and offsets didn't match up to length " + n);
        }
    }

    @Override
    public void assign(DataBuffer ... buffers) {
        long[] offsets = new long[buffers.length];
        long[] strides = new long[buffers.length];
        for (int i = 0; i < strides.length; ++i) {
            strides[i] = 1L;
        }
        this.assign(offsets, strides, buffers);
    }

    @Override
    public void destroy() {
    }

    @Override
    public DataType dataType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o instanceof DataBuffer) {
            DataBuffer d = (DataBuffer)o;
            if (d.length() != this.length()) {
                return false;
            }
            int i = 0;
            while ((long)i < this.length()) {
                double eps = Math.abs(this.getDouble(i) - d.getDouble(i));
                if (eps > 1.0E-12) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private void readObject(ObjectInputStream s) {
        this.doReadObject(s);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.write(out);
    }

    protected void doReadObject(ObjectInputStream s) {
        try {
            s.defaultReadObject();
            Triple<DataBuffer.AllocationMode, Long, DataType> header = BaseDataBuffer.readHeader(s);
            this.read(s, (DataBuffer.AllocationMode)((Object)header.getLeft()), (long)((Long)header.getMiddle()), (DataType)((Object)header.getRight()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Triple<DataBuffer.AllocationMode, Long, DataType> readHeader(@NonNull InputStream is) {
        if (is == null) {
            throw new NullPointerException("is is marked non-null but is null");
        }
        try {
            DataInputStream dis = is instanceof DataInputStream ? (DataInputStream)is : new DataInputStream(is);
            DataBuffer.AllocationMode alloc = DataBuffer.AllocationMode.valueOf(dis.readUTF());
            long length = 0L;
            length = alloc.ordinal() < 3 ? (long)dis.readInt() : dis.readLong();
            DataType type = DataType.valueOf(dis.readUTF());
            return Triple.tripleOf((Object)((Object)alloc), (Object)length, (Object)((Object)type));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void read(DataInputStream s, @NonNull DataBuffer.AllocationMode allocMode, long len, @NonNull DataType dtype) {
        if (allocMode == null) {
            throw new NullPointerException("allocMode is marked non-null but is null");
        }
        if (dtype == null) {
            throw new NullPointerException("dtype is marked non-null but is null");
        }
        try {
            DataBuffer.AllocationMode savedMode = allocMode;
            this.allocationMode = DataBuffer.AllocationMode.MIXED_DATA_TYPES;
            this.type = dtype;
            this.length = len;
            if (savedMode.ordinal() < 3) {
                this.length = len;
                DataType sourceType = dtype;
                this.pointerIndexerByCurrentType(this.type);
                if (sourceType != DataType.COMPRESSED) {
                    DataType thisType = this.dataType();
                    this.readContent(s, sourceType, thisType);
                }
            } else if (savedMode.equals((Object)DataBuffer.AllocationMode.LONG_SHAPE)) {
                DataType currentType;
                this.length = len;
                this.type = currentType = dtype;
                if (currentType == DataType.LONG) {
                    this.elementSize = (byte)8;
                } else if (currentType == DataType.DOUBLE && currentType != DataType.INT) {
                    this.elementSize = (byte)8;
                } else if (currentType == DataType.FLOAT || currentType == DataType.INT) {
                    this.elementSize = (byte)4;
                } else if (currentType == DataType.HALF && currentType != DataType.INT) {
                    this.elementSize = (byte)2;
                }
                this.pointerIndexerByCurrentType(currentType);
                if (currentType != DataType.COMPRESSED) {
                    this.readContent(s, currentType, currentType);
                }
            } else if (this.allocationMode.equals((Object)DataBuffer.AllocationMode.MIXED_DATA_TYPES)) {
                switch (this.type) {
                    case DOUBLE: 
                    case LONG: 
                    case UINT64: {
                        this.elementSize = (byte)8;
                        break;
                    }
                    case FLOAT: 
                    case INT: 
                    case UINT32: {
                        this.elementSize = (byte)4;
                        break;
                    }
                    case HALF: 
                    case SHORT: 
                    case BFLOAT16: 
                    case UINT16: {
                        this.elementSize = (byte)2;
                        break;
                    }
                    case BOOL: 
                    case BYTE: 
                    case UBYTE: 
                    case UTF8: {
                        this.elementSize = 1;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                this.pointerIndexerByCurrentType(this.type);
                if (this.type != DataType.COMPRESSED) {
                    this.readContent(s, this.type, this.type);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void readContent(DataInputStream s, DataType sourceType, DataType thisType) {
        block30: {
            try {
                if (sourceType == DataType.DOUBLE) {
                    AtomicDouble aDbl = new AtomicDouble();
                    for (long i = 0L; i < this.length(); ++i) {
                        aDbl.set(s.readDouble());
                        this.putByDestinationType(i, (Number)aDbl, thisType);
                    }
                    break block30;
                }
                if (sourceType == DataType.FLOAT) {
                    for (long i = 0L; i < this.length(); ++i) {
                        this.putByDestinationType(i, Float.valueOf(s.readFloat()), thisType);
                    }
                    break block30;
                }
                if (sourceType == DataType.COMPRESSED) {
                    String compressionAlgorithm = s.readUTF();
                    long compressedLength = s.readLong();
                    long originalLength = s.readLong();
                    long numberOfElements = s.readLong();
                    this.pointer = new BytePointer(compressedLength);
                    this.type = DataType.COMPRESSED;
                    BytePointer tp = (BytePointer)this.pointer;
                    ByteIndexer ti = ByteIndexer.create((BytePointer)tp);
                    for (long i = 0L; i < compressedLength; ++i) {
                        ti.put(i, s.readByte());
                    }
                    break block30;
                }
                if (sourceType == DataType.HALF) {
                    AtomicInteger aInt = new AtomicInteger();
                    for (long i = 0L; i < this.length(); ++i) {
                        aInt.set(s.readShort());
                        this.putByDestinationType(i, Float.valueOf(HalfIndexer.toFloat((int)aInt.get())), thisType);
                    }
                    break block30;
                }
                if (sourceType == DataType.BFLOAT16) {
                    AtomicInteger aInt = new AtomicInteger();
                    for (long i = 0L; i < this.length(); ++i) {
                        aInt.set(s.readShort());
                        this.putByDestinationType(i, Float.valueOf(Bfloat16Indexer.toFloat((int)aInt.get())), thisType);
                    }
                    break block30;
                }
                if (sourceType == DataType.UINT64) {
                    AtomicLong aLong = new AtomicLong();
                    for (long i = 0L; i < this.length(); ++i) {
                        aLong.set(s.readLong());
                        this.putByDestinationType(i, aLong, thisType);
                    }
                    break block30;
                }
                if (sourceType == DataType.LONG) {
                    AtomicLong aLong = new AtomicLong();
                    for (long i = 0L; i < this.length(); ++i) {
                        aLong.set(s.readLong());
                        this.putByDestinationType(i, aLong, thisType);
                    }
                    break block30;
                }
                if (sourceType == DataType.UINT32) {
                    AtomicLong aLong = new AtomicLong();
                    for (long i = 0L; i < this.length(); ++i) {
                        aLong.set(s.readInt());
                        this.putByDestinationType(i, aLong, thisType);
                    }
                    break block30;
                }
                if (sourceType == DataType.INT) {
                    AtomicInteger aInt = new AtomicInteger();
                    for (long i = 0L; i < this.length(); ++i) {
                        aInt.set(s.readInt());
                        this.putByDestinationType(i, aInt, thisType);
                    }
                    break block30;
                }
                if (sourceType == DataType.UINT16) {
                    AtomicInteger aInt = new AtomicInteger();
                    for (long i = 0L; i < this.length(); ++i) {
                        aInt.set(s.readShort());
                        this.putByDestinationType(i, aInt, thisType);
                    }
                    break block30;
                }
                if (sourceType == DataType.SHORT) {
                    AtomicInteger aInt = new AtomicInteger();
                    for (long i = 0L; i < this.length(); ++i) {
                        aInt.set(s.readShort());
                        this.putByDestinationType(i, aInt, thisType);
                    }
                    break block30;
                }
                if (sourceType == DataType.UBYTE) {
                    AtomicInteger aInt = new AtomicInteger();
                    for (long i = 0L; i < this.length(); ++i) {
                        aInt.set(s.readByte());
                        this.putByDestinationType(i, aInt, thisType);
                    }
                    break block30;
                }
                if (sourceType == DataType.BYTE) {
                    AtomicInteger aInt = new AtomicInteger();
                    for (long i = 0L; i < this.length(); ++i) {
                        aInt.set(s.readByte());
                        this.putByDestinationType(i, aInt, thisType);
                    }
                    break block30;
                }
                if (sourceType == DataType.BOOL) {
                    AtomicInteger aInt = new AtomicInteger();
                    for (long i = 0L; i < this.length(); ++i) {
                        aInt.set(s.readByte());
                        this.putByDestinationType(i, aInt, thisType);
                    }
                    break block30;
                }
                throw new UnsupportedOperationException("Cannot read type: " + (Object)((Object)sourceType) + " to " + (Object)((Object)thisType));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected abstract double getDoubleUnsynced(long var1);

    protected abstract float getFloatUnsynced(long var1);

    protected abstract long getLongUnsynced(long var1);

    protected abstract int getIntUnsynced(long var1);

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeUTF(this.allocationMode.name());
        out.writeLong(this.length());
        out.writeUTF(this.dataType().name());
        switch (this.dataType()) {
            case DOUBLE: {
                for (long i = 0L; i < this.length(); ++i) {
                    out.writeDouble(this.getDoubleUnsynced(i));
                }
                break;
            }
            case LONG: 
            case UINT64: {
                for (long i = 0L; i < this.length(); ++i) {
                    out.writeLong(this.getLongUnsynced(i));
                }
                break;
            }
            case INT: 
            case UINT32: {
                for (long i = 0L; i < this.length(); ++i) {
                    out.writeInt(this.getIntUnsynced(i));
                }
                break;
            }
            case SHORT: 
            case UINT16: {
                for (long i = 0L; i < this.length(); ++i) {
                    out.writeShort((short)this.getIntUnsynced(i));
                }
                break;
            }
            case BYTE: 
            case UBYTE: {
                for (long i = 0L; i < this.length(); ++i) {
                    out.writeByte((byte)this.getIntUnsynced(i));
                }
                break;
            }
            case BOOL: {
                for (long i = 0L; i < this.length(); ++i) {
                    out.writeByte(this.getIntUnsynced(i) == 0 ? 0 : 1);
                }
                break;
            }
            case BFLOAT16: {
                for (long i = 0L; i < this.length(); ++i) {
                    out.writeShort((short)Bfloat16Indexer.fromFloat((float)this.getFloatUnsynced(i)));
                }
                break;
            }
            case HALF: {
                for (long i = 0L; i < this.length(); ++i) {
                    out.writeShort((short)HalfIndexer.fromFloat((float)this.getFloatUnsynced(i)));
                }
                break;
            }
            case FLOAT: {
                for (long i = 0L; i < this.length(); ++i) {
                    out.writeFloat(this.getFloatUnsynced(i));
                }
                break;
            }
        }
    }

    public float toFloat(int hbits) {
        int mant = hbits & 0x3FF;
        int exp = hbits & 0x7C00;
        if (exp == 31744) {
            exp = 261120;
        } else if (exp != 0) {
            exp += 114688;
        } else if (mant != 0) {
            exp = 115712;
            do {
                exp -= 1024;
            } while (((mant <<= 1) & 0x400) == 0);
            mant &= 0x3FF;
        }
        return Float.intBitsToFloat((hbits & 0x8000) << 16 | (exp | mant) << 13);
    }

    @Override
    public Object array() {
        return null;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[");
        int max = TO_STRING_MAX >= 0 ? (int)Math.min(this.length(), (long)TO_STRING_MAX) : (int)Math.min(this.length(), Integer.MAX_VALUE);
        for (int i = 0; i < max; ++i) {
            switch (this.dataType()) {
                case BYTE: 
                case UBYTE: 
                case SHORT: 
                case INT: 
                case LONG: {
                    ret.append(this.getNumber(i).intValue());
                    break;
                }
                case BOOL: {
                    ret.append(this.getNumber(i).intValue() == 0 ? " false" : " true");
                    break;
                }
                case UTF8: {
                    throw new UnsupportedOperationException();
                }
                default: {
                    ret.append(this.getNumber(i).floatValue());
                }
            }
            if (i >= max - 1) continue;
            ret.append(",");
        }
        if ((long)max < this.length()) {
            ret.append(",<").append(this.length() - (long)max).append(" more elements>");
        }
        ret.append("]");
        return ret.toString();
    }

    public int hashCode() {
        int result = (int)this.length;
        result = 31 * result + (this.allocationMode != null ? this.allocationMode.hashCode() : 0);
        return result;
    }

    @Override
    public long originalOffset() {
        return this.originalOffset;
    }

    @Override
    public boolean isConstant() {
        return this.constant;
    }

    @Override
    public void setConstant(boolean reallyConstant) {
        this.constant = reallyConstant;
    }

    @Override
    public boolean isAttached() {
        return this.attached;
    }

    @Override
    public boolean isInScope() {
        if (!this.isAttached()) {
            return true;
        }
        return this.parentWorkspace.isScopeActive();
    }

    @Override
    public MemoryWorkspace getParentWorkspace() {
        if (this.parentWorkspace != null) {
            return this.parentWorkspace;
        }
        if (this.wrappedDataBuffer != null && this.wrappedDataBuffer.isAttached() && this.wrappedDataBuffer.getParentWorkspace() != null) {
            return this.wrappedDataBuffer.getParentWorkspace();
        }
        if (this.originalBuffer != null && this.originalBuffer.isAttached() && this.originalBuffer.getParentWorkspace() != null) {
            return this.originalBuffer.getParentWorkspace();
        }
        return null;
    }

    @Override
    public abstract DataBuffer reallocate(long var1);

    @Override
    public long capacity() {
        return this.pointer().capacity();
    }

    @Override
    public boolean closeable() {
        if (this.released || this.isAttached() || this.isConstant()) {
            return false;
        }
        return this.wrappedDataBuffer == null || this.wrappedDataBuffer == this;
    }

    protected void markReleased() {
        this.released = true;
    }

    @Override
    public void close() {
        if (!this.closeable()) {
            throw new IllegalStateException("Can't release this data buffer");
        }
        this.release();
    }

    protected void release() {
        this.released = true;
        this.indexer = null;
        this.pointer = null;
    }

    @Override
    public long platformAddress() {
        return this.address();
    }

    @Override
    public boolean wasClosed() {
        if (this.wrappedDataBuffer != null && this.wrappedDataBuffer != this) {
            return this.wrappedDataBuffer.wasClosed();
        }
        return this.released;
    }

    public abstract void syncToPrimary();

    public abstract void syncToSpecial();

    static {
        String s = System.getProperty("org.nd4j.databuffer.tostring.maxelements");
        if (s != null) {
            try {
                TO_STRING_MAX = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid value for key {}: \"{}\"", (Object)"org.nd4j.databuffer.tostring.maxelements", (Object)s);
                TO_STRING_MAX = 1000;
            }
        } else {
            TO_STRING_MAX = 1000;
        }
    }
}

