/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.util.SameDiffUtils;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseIndexAccumulation
extends BaseOp
implements IndexAccumulation {
    private static final Logger log = LoggerFactory.getLogger(BaseIndexAccumulation.class);
    protected boolean keepDims = false;

    public BaseIndexAccumulation(SameDiff sameDiff, SDVariable i_v, boolean keepDims, int[] dimensions) {
        super(sameDiff, (Object[])null);
        if (i_v == null) {
            throw new IllegalArgumentException("Input not null variable.");
        }
        this.dimensions = dimensions;
        sameDiff.addArgsFor(new SDVariable[]{i_v}, (DifferentialFunction)this);
        this.xVertexId = i_v.name();
        this.keepDims = keepDims;
        this.defineDimensions(dimensions);
    }

    public BaseIndexAccumulation(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, boolean keepDims, int[] dimensions) {
        super(sameDiff, (Object[])null);
        if (i_v == null) {
            throw new IllegalArgumentException("Input not null variable.");
        }
        this.dimensions = dimensions;
        SameDiffUtils.validateDifferentialFunctionSameDiff(sameDiff, i_v, this);
        SameDiffUtils.validateDifferentialFunctionSameDiff(sameDiff, i_v2, this);
        this.xVertexId = i_v.name();
        this.yVertexId = i_v2.name();
        sameDiff.addArgsFor(new SDVariable[]{i_v, i_v2}, (DifferentialFunction)this);
        this.keepDims = keepDims;
        this.defineDimensions(dimensions);
    }

    public BaseIndexAccumulation() {
    }

    public BaseIndexAccumulation(INDArray x, int[] dimensions) {
        this(x, null, dimensions);
    }

    public BaseIndexAccumulation(INDArray x, boolean keepDims, int[] dimensions) {
        this(x, null, dimensions);
        this.keepDims = keepDims;
        this.defineDimensions(dimensions);
    }

    public BaseIndexAccumulation(INDArray x, INDArray z, int[] dimensions) {
        super(x, z);
        this.defineDimensions(dimensions);
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape() {
        return this.calculateOutputShape(null);
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape(OpContext oc) {
        INDArray x;
        INDArray iNDArray = x = oc != null ? oc.getInputArray(0) : this.x();
        if (x == null) {
            return Collections.emptyList();
        }
        long[] reducedShape = Shape.getReducedShape(x.shape(), this.dimensions, this.keepDims);
        return Collections.singletonList(LongShapeDescriptor.fromShape(reducedShape, DataType.LONG));
    }

    @Override
    public Op.Type opType() {
        return Op.Type.INDEXREDUCE;
    }

    @Override
    public boolean validateDataTypes() {
        if (this.z() != null) {
            Preconditions.checkArgument((this.z().dataType() == DataType.LONG ? 1 : 0) != 0, (String)"IndexReduce operations require LONG output: got result array of type %s for op %s", (Object)((Object)this.z.dataType()), this.getClass());
        }
        return true;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatype for %s, got input %s", this.getClass(), dataTypes);
        return Collections.singletonList(DataType.LONG);
    }

    @Override
    public boolean isKeepDims() {
        return this.keepDims;
    }

    public void setKeepDims(boolean keepDims) {
        this.keepDims = keepDims;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseIndexAccumulation)) {
            return false;
        }
        BaseIndexAccumulation other = (BaseIndexAccumulation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isKeepDims() == other.isKeepDims();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseIndexAccumulation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isKeepDims() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "BaseIndexAccumulation(keepDims=" + this.isKeepDims() + ")";
    }
}

